/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.core.MultipartInput;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MultipartStreamTest {
    private static final String BOUNDARY_TEXT = "myboundary";

    MultipartStreamTest() {
    }

    @Test
    public void testPartHeaderSizeMaxLimit() throws Exception {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        byte[] byteContents = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream input = new ByteArrayInputStream(byteContents);
        byte[] boundary = "---1234".getBytes();
        MultipartInput mi = ((MultipartInput.Builder)MultipartInput.builder().setInputStream((InputStream)input)).setBoundary(boundary).setMaxPartHeaderSize(100).get();
        Assertions.assertNotNull((Object)mi);
        try {
            boolean nextPart = mi.skipPreamble();
            while (nextPart) {
                String headers = mi.readHeaders();
                System.out.print("Headers=" + headers.length() + ", " + headers);
                Assertions.assertNotNull((Object)headers);
                mi.readBodyData((OutputStream)NullOutputStream.INSTANCE);
                nextPart = mi.readBoundary();
            }
            Assertions.fail((String)"Expected Exception");
        }
        catch (FileUploadSizeException fuse) {
            Assertions.assertEquals((long)100L, (long)fuse.getPermitted());
        }
    }

    @Test
    void testSmallBuffer() {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        boolean iBufSize = true;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((MultipartInput.Builder)((MultipartInput.Builder)MultipartInput.builder().setInputStream(input)).setBoundary(boundary).setBufferSize(1)).setProgressNotifier(new MultipartInput.ProgressNotifier(null, (long)contents.length)).get());
    }

    @Test
    void testThreeParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        int iBufSize = boundary.length + MultipartInput.BOUNDARY_PREFIX.length + 1;
        MultipartInput ms = ((MultipartInput.Builder)((MultipartInput.Builder)MultipartInput.builder().setInputStream((InputStream)input)).setBoundary(boundary).setBufferSize(iBufSize)).setProgressNotifier(new MultipartInput.ProgressNotifier(null, (long)contents.length)).get();
        Assertions.assertNotNull((Object)ms);
    }

    @Test
    void testTwoParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        MultipartInput ms = ((MultipartInput.Builder)MultipartInput.builder().setInputStream((InputStream)input)).setBoundary(boundary).setProgressNotifier(new MultipartInput.ProgressNotifier(null, (long)contents.length)).get();
        Assertions.assertNotNull((Object)ms);
    }
}

