/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.html.HTML;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.util.StringUtils;

public class HtmlTools {
    private static final HTML.Tag[] ALL_TAGS = new HTML.Tag[]{HtmlMarkup.A, HtmlMarkup.ABBR, HtmlMarkup.ACRONYM, HtmlMarkup.ADDRESS, HtmlMarkup.APPLET, HtmlMarkup.AREA, HtmlMarkup.B, HtmlMarkup.BASE, HtmlMarkup.BASEFONT, HtmlMarkup.BDO, HtmlMarkup.BIG, HtmlMarkup.BLOCKQUOTE, HtmlMarkup.BODY, HtmlMarkup.BR, HtmlMarkup.BUTTON, HtmlMarkup.CAPTION, HtmlMarkup.CENTER, HtmlMarkup.CITE, HtmlMarkup.CODE, HtmlMarkup.COL, HtmlMarkup.COLGROUP, HtmlMarkup.DD, HtmlMarkup.DEL, HtmlMarkup.DFN, HtmlMarkup.DIR, HtmlMarkup.DIV, HtmlMarkup.DL, HtmlMarkup.DT, HtmlMarkup.EM, HtmlMarkup.FIELDSET, HtmlMarkup.FONT, HtmlMarkup.FORM, HtmlMarkup.FRAME, HtmlMarkup.FRAMESET, HtmlMarkup.H1, HtmlMarkup.H2, HtmlMarkup.H3, HtmlMarkup.H4, HtmlMarkup.H5, HtmlMarkup.H6, HtmlMarkup.HEAD, HtmlMarkup.HR, HtmlMarkup.HTML, HtmlMarkup.I, HtmlMarkup.IFRAME, HtmlMarkup.IMG, HtmlMarkup.INPUT, HtmlMarkup.INS, HtmlMarkup.ISINDEX, HtmlMarkup.KBD, HtmlMarkup.LABEL, HtmlMarkup.LEGEND, HtmlMarkup.LI, HtmlMarkup.LINK, HtmlMarkup.MAP, HtmlMarkup.MENU, HtmlMarkup.META, HtmlMarkup.NOFRAMES, HtmlMarkup.NOSCRIPT, HtmlMarkup.OBJECT, HtmlMarkup.OL, HtmlMarkup.OPTGROUP, HtmlMarkup.OPTION, HtmlMarkup.P, HtmlMarkup.PARAM, HtmlMarkup.PRE, HtmlMarkup.Q, HtmlMarkup.S, HtmlMarkup.SAMP, HtmlMarkup.SCRIPT, HtmlMarkup.SELECT, HtmlMarkup.SMALL, HtmlMarkup.SPAN, HtmlMarkup.STRIKE, HtmlMarkup.STRONG, HtmlMarkup.STYLE, HtmlMarkup.SUB, HtmlMarkup.SUP, HtmlMarkup.TABLE, HtmlMarkup.TBODY, HtmlMarkup.TD, HtmlMarkup.TEXTAREA, HtmlMarkup.TFOOT, HtmlMarkup.TH, HtmlMarkup.THEAD, HtmlMarkup.TITLE, HtmlMarkup.TR, HtmlMarkup.TT, HtmlMarkup.U, HtmlMarkup.UL, HtmlMarkup.VAR};
    private static final Map<String, HTML.Tag> TAG_MAP = new HashMap<String, HTML.Tag>(ALL_TAGS.length);
    private static final int ASCII = 126;
    private static final char LUNATE_SIGMA = '\u03ff';
    private static final char NON_PRIVATE_USE_HIGH_SURROGATE = '\ud800';
    private static final char LOW_SURROGATE = '\udc00';
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private static final int MIN_CODE_POINT = 0;
    private static final int MAX_CODE_POINT = 0x10FFFF;
    private static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;

    public static HTML.Tag getHtmlTag(String tagName) {
        HTML.Tag t = TAG_MAP.get(tagName);
        return t;
    }

    public static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text, true);
    }

    public static String escapeHTML(String text, boolean xmlMode) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block6: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    if (xmlMode) {
                        if (c == '\'') {
                            buffer.append("&apos;");
                            continue block6;
                        }
                        buffer.append(c);
                        continue block6;
                    }
                    if (c <= '~') {
                        buffer.append(c);
                        continue block6;
                    }
                    buffer.append("&#x");
                    if (HtmlTools.isHighSurrogate(c)) {
                        buffer.append(Integer.toHexString(HtmlTools.toCodePoint(c, text.charAt(++i))));
                    } else {
                        buffer.append(Integer.toHexString(c));
                    }
                    buffer.append(';');
                }
            }
        }
        return buffer.toString();
    }

    public static String unescapeHTML(String text) {
        return HtmlTools.unescapeHTML(text, false);
    }

    public static String unescapeHTML(String text, boolean xmlMode) {
        int i;
        if (text == null) {
            return null;
        }
        String unescaped = xmlMode ? StringEscapeUtils.unescapeXml(text) : StringEscapeUtils.unescapeHtml(text);
        String tmp = unescaped;
        ArrayList<String> entities = new ArrayList<String>();
        while ((i = tmp.indexOf("&#x")) != -1) {
            if ((tmp = tmp.substring(i + 3)).indexOf(59) == -1) continue;
            String entity = tmp.substring(0, tmp.indexOf(59));
            try {
                Integer.parseInt(entity, 16);
                entities.add(entity);
            }
            catch (NumberFormatException e) {}
        }
        for (String entity : entities) {
            int codePoint = Integer.parseInt(entity, 16);
            unescaped = StringUtils.replace(unescaped, "&#x" + entity + ";", new String(HtmlTools.toChars(codePoint)));
        }
        return unescaped;
    }

    public static String encodeURL(String url) {
        if (url == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder();
        int length = url.length();
        char[] unicode = new char[1];
        block5: for (int i = 0; i < length; ++i) {
            char c = url.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '_': 
                case '~': {
                    encoded.append(c);
                    continue block5;
                }
                default: {
                    byte[] bytes;
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        encoded.append(c);
                        continue block5;
                    }
                    try {
                        if (HtmlTools.isHighSurrogate(c)) {
                            int codePoint = HtmlTools.toCodePoint(c, url.charAt(++i));
                            unicode = HtmlTools.toChars(codePoint);
                            bytes = new String(unicode, 0, unicode.length).getBytes("UTF8");
                        } else {
                            unicode[0] = c;
                            bytes = new String(unicode, 0, 1).getBytes("UTF8");
                        }
                    }
                    catch (UnsupportedEncodingException cannotHappen) {
                        bytes = new byte[]{};
                    }
                    for (int j = 0; j < bytes.length; ++j) {
                        String hex = DoxiaUtils.byteToHex(bytes[j]);
                        encoded.append('%');
                        if (hex.length() == 1) {
                            encoded.append('0');
                        }
                        encoded.append(hex);
                    }
                }
            }
        }
        return encoded.toString();
    }

    public static String encodeId(String id) {
        return DoxiaUtils.encodeId(id, true);
    }

    public static boolean isId(String text) {
        return DoxiaUtils.isValidId(text);
    }

    private HtmlTools() {
    }

    private static int toCodePoint(char high, char low) {
        int h = (high & 0x3FF) << 10;
        int l = low & 0x3FF;
        return (h | l) + 65536;
    }

    private static boolean isHighSurrogate(char ch) {
        return '\ud800' <= ch && '\udbff' >= ch;
    }

    private static boolean isValidCodePoint(int codePoint) {
        return 0 <= codePoint && 0x10FFFF >= codePoint;
    }

    private static boolean isSupplementaryCodePoint(int codePoint) {
        return 65536 <= codePoint && 0x10FFFF >= codePoint;
    }

    public static char[] toChars(int codePoint) {
        if (!HtmlTools.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        if (HtmlTools.isSupplementaryCodePoint(codePoint)) {
            int cpPrime = codePoint - 65536;
            int high = 0xD800 | cpPrime >> 10 & 0x3FF;
            int low = 0xDC00 | cpPrime & 0x3FF;
            return new char[]{(char)high, (char)low};
        }
        return new char[]{(char)codePoint};
    }

    static {
        for (HTML.Tag tag : ALL_TAGS) {
            TAG_MAP.put(tag.toString(), tag);
        }
    }
}

