/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;

public abstract class AbstractSelectInput
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog(AbstractSelectInput.class);

    public boolean execute(ActionContext actionCtx) throws Exception {
        ForwardConfig forwardConfig;
        Boolean valid = actionCtx.getFormValid();
        if (valid != null && valid.booleanValue()) {
            return false;
        }
        ActionConfig actionConfig = actionCtx.getActionConfig();
        ModuleConfig moduleConfig = actionConfig.getModuleConfig();
        String input = actionConfig.getInput();
        if (moduleConfig.getControllerConfig().getInputForward()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Finding ForwardConfig for '" + input + "'");
            }
            if ((forwardConfig = actionConfig.findForwardConfig(input)) == null) {
                forwardConfig = moduleConfig.findForwardConfig(input);
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Delegating to forward() for '" + input + "'");
            }
            forwardConfig = this.forward(actionCtx, moduleConfig, input);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding back to " + forwardConfig);
        }
        actionCtx.setForwardConfig(forwardConfig);
        return false;
    }

    protected abstract ForwardConfig forward(ActionContext var1, ModuleConfig var2, String var3);
}

