/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.WildcardHelper;

public class ActionConfigMatcher
implements Serializable {
    private static final Log log = LogFactory.getLog(ActionConfigMatcher.class);
    private static final WildcardHelper wildcard = new WildcardHelper();
    private List compiledPaths = new ArrayList();

    public ActionConfigMatcher(ActionConfig[] configs) {
        for (int x = 0; x < configs.length; ++x) {
            String path = configs[x].getPath();
            if (path == null || path.indexOf(42) <= -1) continue;
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (log.isDebugEnabled()) {
                log.debug("Compiling action config path '" + path + "'");
            }
            int[] pattern = wildcard.compilePattern(path);
            this.compiledPaths.add(new Mapping(pattern, configs[x]));
        }
    }

    public ActionConfig match(String path) {
        ActionConfig config = null;
        if (this.compiledPaths.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Attempting to match '" + path + "' to a wildcard pattern");
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            HashMap vars = new HashMap();
            Iterator i = this.compiledPaths.iterator();
            while (i.hasNext()) {
                Mapping m = (Mapping)i.next();
                if (!wildcard.match(vars, path, m.getPattern())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Path matches pattern '" + m.getActionConfig().getPath() + "'");
                }
                config = this.convertActionConfig(path, m.getActionConfig(), vars);
            }
        }
        return config;
    }

    protected ActionConfig convertActionConfig(String path, ActionConfig orig, Map vars) {
        ActionConfig config = null;
        try {
            config = (ActionConfig)BeanUtils.cloneBean(orig);
        }
        catch (Exception ex) {
            log.warn("Unable to clone action config, recommend not using wildcards", ex);
            return null;
        }
        config.setName(this.convertParam(orig.getName(), vars));
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = "/" + path;
        }
        config.setPath(path);
        config.setType(this.convertParam(orig.getType(), vars));
        config.setRoles(this.convertParam(orig.getRoles(), vars));
        config.setParameter(this.convertParam(orig.getParameter(), vars));
        config.setAttribute(this.convertParam(orig.getAttribute(), vars));
        config.setForward(this.convertParam(orig.getForward(), vars));
        config.setInclude(this.convertParam(orig.getInclude(), vars));
        config.setInput(this.convertParam(orig.getInput(), vars));
        config.setCatalog(this.convertParam(orig.getCatalog(), vars));
        config.setCommand(this.convertParam(orig.getCommand(), vars));
        config.setMultipartClass(this.convertParam(orig.getMultipartClass(), vars));
        config.setPrefix(this.convertParam(orig.getPrefix(), vars));
        config.setSuffix(this.convertParam(orig.getSuffix(), vars));
        ForwardConfig[] fConfigs = orig.findForwardConfigs();
        for (int x = 0; x < fConfigs.length; ++x) {
            ActionForward cfg = new ActionForward();
            cfg.setName(fConfigs[x].getName());
            cfg.setPath(this.convertParam(fConfigs[x].getPath(), vars));
            cfg.setRedirect(fConfigs[x].getRedirect());
            cfg.setCommand(this.convertParam(fConfigs[x].getCommand(), vars));
            cfg.setCatalog(this.convertParam(fConfigs[x].getCatalog(), vars));
            cfg.setModule(this.convertParam(fConfigs[x].getModule(), vars));
            this.replaceProperties(fConfigs[x].getProperties(), cfg.getProperties(), vars);
            config.removeForwardConfig(fConfigs[x]);
            config.addForwardConfig(cfg);
        }
        this.replaceProperties(orig.getProperties(), config.getProperties(), vars);
        ExceptionConfig[] exConfigs = orig.findExceptionConfigs();
        for (int x = 0; x < exConfigs.length; ++x) {
            config.addExceptionConfig(exConfigs[x]);
        }
        config.freeze();
        return config;
    }

    protected void replaceProperties(Properties orig, Properties props, Map vars) {
        Map.Entry<Object, Object> entry = null;
        Iterator<Map.Entry<Object, Object>> i = orig.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            props.setProperty((String)entry.getKey(), this.convertParam((String)entry.getValue(), vars));
        }
    }

    protected String convertParam(String val, Map vars) {
        if (val == null) {
            return null;
        }
        if (val.indexOf("{") == -1) {
            return val;
        }
        StringBuffer key = new StringBuffer("{0}");
        StringBuffer ret = new StringBuffer(val);
        Iterator i = vars.entrySet().iterator();
        while (i.hasNext()) {
            int x;
            Map.Entry entry = i.next();
            key.setCharAt(1, ((String)entry.getKey()).charAt(0));
            String keyTmp = key.toString();
            while ((x = ret.toString().indexOf(keyTmp)) > -1) {
                ret.replace(x, x + 3, (String)entry.getValue());
            }
        }
        return ret.toString();
    }

    private class Mapping
    implements Serializable {
        private int[] pattern;
        private ActionConfig config;

        public Mapping(int[] pattern, ActionConfig config) {
            this.pattern = pattern;
            this.config = config;
        }

        public int[] getPattern() {
            return this.pattern;
        }

        public ActionConfig getActionConfig() {
            return this.config;
        }
    }
}

