/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.artifact;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.opensaml.saml.common.binding.artifact.SAMLSourceIDArtifact;
import org.opensaml.saml.saml1.binding.artifact.AbstractSAML1Artifact;

public class SAML1ArtifactType0001
extends AbstractSAML1Artifact
implements SAMLSourceIDArtifact {
    @Nonnull
    public static final byte[] TYPE_CODE = new byte[]{0, 1};
    @Nonnull
    private byte[] sourceID;
    @Nonnull
    private byte[] assertionHandle;

    public SAML1ArtifactType0001() {
        this(new byte[20], new byte[20]);
    }

    public SAML1ArtifactType0001(@Nonnull byte[] source, @Nonnull byte[] handle) {
        super(TYPE_CODE);
        if (source.length != 20) {
            throw new IllegalArgumentException("Artifact source ID must be 20 bytes long");
        }
        this.sourceID = source;
        if (handle.length != 20) {
            throw new IllegalArgumentException("Artifact assertion handle must be 20 bytes long");
        }
        this.assertionHandle = handle;
    }

    public static SAML1ArtifactType0001 parseArtifact(byte[] artifact) {
        if (artifact.length != 42) {
            throw new IllegalArgumentException("Artifact length must be 42 bytes it was " + artifact.length + "bytes");
        }
        byte[] typeCode = new byte[]{artifact[0], artifact[1]};
        if (!Arrays.equals(typeCode, TYPE_CODE)) {
            throw new IllegalArgumentException("Artifact is not of appropriate type.");
        }
        byte[] sourceID = new byte[20];
        System.arraycopy(artifact, 2, sourceID, 0, 20);
        byte[] assertionHandle = new byte[20];
        System.arraycopy(artifact, 22, assertionHandle, 0, 20);
        return new SAML1ArtifactType0001(sourceID, assertionHandle);
    }

    @Override
    @Nonnull
    public byte[] getSourceID() {
        return this.sourceID;
    }

    protected void setSourceID(@Nonnull byte[] newSourceID) {
        if (newSourceID.length != 20) {
            throw new IllegalArgumentException("Artifact source ID must be 20 bytes long");
        }
        this.sourceID = newSourceID;
    }

    @Nonnull
    public byte[] getAssertionHandle() {
        return this.assertionHandle;
    }

    public void setAssertionHandle(@Nonnull byte[] handle) {
        if (handle.length != 20) {
            throw new IllegalArgumentException("Artifact assertion handle must be 20 bytes long");
        }
        this.assertionHandle = handle;
    }

    @Override
    @Nonnull
    public byte[] getRemainingArtifact() {
        byte[] remainingArtifact = new byte[40];
        System.arraycopy(this.getSourceID(), 0, remainingArtifact, 0, 20);
        System.arraycopy(this.getAssertionHandle(), 0, remainingArtifact, 20, 20);
        return remainingArtifact;
    }
}

