/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import javax.annotation.Nonnull;
import net.shibboleth.shared.httpclient.HttpClientBuilder;
import net.shibboleth.shared.logic.Constraint;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.impl.cache.BasicHttpCacheStorage;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingHttpClientBuilder;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;

public class InMemoryCachingHttpClientBuilder
extends HttpClientBuilder {
    private int maxCacheEntries = 50;
    private long maxCacheEntrySize = 0x100000L;

    public InMemoryCachingHttpClientBuilder() {
        this(CachingHttpClientBuilder.create());
    }

    public InMemoryCachingHttpClientBuilder(@Nonnull CachingHttpClientBuilder builder) {
        super((org.apache.hc.client5.http.impl.classic.HttpClientBuilder)builder);
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxEntries) {
        this.maxCacheEntries = Constraint.isGreaterThan((int)0, (int)maxEntries, (String)"Maximum number of cache entries must be greater than 0");
    }

    public long getMaxCacheEntrySize() {
        return this.maxCacheEntrySize;
    }

    public void setMaxCacheEntrySize(long size) {
        this.maxCacheEntrySize = Constraint.isGreaterThan((long)0L, (long)size, (String)"Maximum cache entry size must be greater than 0");
    }

    @Override
    protected void decorateApacheBuilder() throws Exception {
        super.decorateApacheBuilder();
        CachingHttpClientBuilder cachingBuilder = (CachingHttpClientBuilder)this.getApacheBuilder();
        CacheConfig.Builder cacheConfigBuilder = CacheConfig.custom();
        cacheConfigBuilder.setMaxCacheEntries(this.maxCacheEntries);
        cacheConfigBuilder.setMaxObjectSize(this.maxCacheEntrySize);
        cacheConfigBuilder.setHeuristicCachingEnabled(false);
        cacheConfigBuilder.setSharedCache(false);
        CacheConfig cacheConfig = cacheConfigBuilder.build();
        cachingBuilder.setCacheConfig(cacheConfig);
        cachingBuilder.setResourceFactory((ResourceFactory)new HeapResourceFactory());
        cachingBuilder.setHttpCacheStorage((HttpCacheStorage)new BasicHttpCacheStorage(cacheConfig));
    }
}

