/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AllowedMethodsHandler
implements HttpHandler {
    private final Set<HttpString> allowedMethods;
    private final HttpHandler next;

    public AllowedMethodsHandler(HttpHandler next, Set<HttpString> allowedMethods) {
        this.allowedMethods = new HashSet<HttpString>(allowedMethods);
        this.next = next;
    }

    public AllowedMethodsHandler(HttpHandler next, HttpString ... allowedMethods) {
        this.allowedMethods = new HashSet<HttpString>(Arrays.asList(allowedMethods));
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.allowedMethods.contains(exchange.getRequestMethod())) {
            this.next.handleRequest(exchange);
        } else {
            exchange.setStatusCode(405);
            exchange.endExchange();
        }
    }

    public Set<HttpString> getAllowedMethods() {
        return Collections.unmodifiableSet(this.allowedMethods);
    }

    public String toString() {
        if (this.allowedMethods.size() == 1) {
            return "allowed-methods( " + String.valueOf(this.allowedMethods.toArray()[0]) + " )";
        }
        return "allowed-methods( {" + this.allowedMethods.stream().map(s -> s.toString()).collect(Collectors.joining(", ")) + "} )";
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String[] methods;

        private Wrapper(String[] methods) {
            this.methods = methods;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            HttpString[] strings = new HttpString[this.methods.length];
            for (int i = 0; i < this.methods.length; ++i) {
                strings[i] = new HttpString(this.methods[i]);
            }
            return new AllowedMethodsHandler(handler, strings);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "allowed-methods";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("methods", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("methods");
        }

        @Override
        public String defaultParameter() {
            return "methods";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String[])config.get("methods"));
        }
    }
}

