/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesQuickSelectSketchR;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesQuickSelectSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesCompactSketchTest {
    @Test
    public void heapToDirectExactTwoDoubles() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        ArrayOfDoublesCompactSketch csk = sketch1.compact();
        Memory mem = Memory.wrap((byte[])csk.toByteArray());
        DirectArrayOfDoublesCompactSketch sketch2 = new DirectArrayOfDoublesCompactSketch(mem);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)4.0);
        Assert.assertEquals((double)sketch2.getUpperBound(1), (double)4.0);
        Assert.assertEquals((double)sketch2.getLowerBound(1), (double)4.0);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch2.getTheta(), (double)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)4);
        for (double[] array : values) {
            Assert.assertEquals((int)array.length, (int)2);
            Assert.assertEquals((double)array[0], (double)2.0);
            Assert.assertEquals((double)array[1], (double)4.0);
        }
    }

    @Test
    public void directToHeapExactTwoDoubles() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build(WritableMemory.writableWrap((byte[])new byte[1000000]));
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        HeapArrayOfDoublesCompactSketch sketch2 = new HeapArrayOfDoublesCompactSketch(Memory.wrap((byte[])sketch1.compact(WritableMemory.writableWrap((byte[])new byte[1000000])).toByteArray()));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)4.0);
        Assert.assertEquals((double)sketch2.getUpperBound(1), (double)4.0);
        Assert.assertEquals((double)sketch2.getLowerBound(1), (double)4.0);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch2.getTheta(), (double)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)4);
        for (double[] array : values) {
            Assert.assertEquals((int)array.length, (int)2);
            Assert.assertEquals((double)array[0], (double)2.0);
            Assert.assertEquals((double)array[1], (double)4.0);
        }
    }

    @Test
    public void checkGetValuesAndKeysMethods() {
        ArrayOfDoublesUpdatableSketchBuilder bldr = new ArrayOfDoublesUpdatableSketchBuilder();
        bldr.setNominalEntries(16).setNumberOfValues(2);
        HeapArrayOfDoublesQuickSelectSketch hqssk = (HeapArrayOfDoublesQuickSelectSketch)bldr.build();
        hqssk.update("a", new double[]{1.0, 2.0});
        hqssk.update("b", new double[]{3.0, 4.0});
        hqssk.update("c", new double[]{5.0, 6.0});
        hqssk.update("d", new double[]{7.0, 8.0});
        double[][] values = hqssk.getValues();
        double[] values1d = hqssk.getValuesAsOneDimension();
        long[] keys = hqssk.getKeys();
        HeapArrayOfDoublesCompactSketch hcsk = (HeapArrayOfDoublesCompactSketch)hqssk.compact();
        double[][] values2 = hcsk.getValues();
        double[] values1d2 = hcsk.getValuesAsOneDimension();
        long[] keys2 = hcsk.getKeys();
        Assert.assertEquals((Object[])values2, (Object[])values);
        Assert.assertEquals((double[])values1d2, (double[])values1d);
        Assert.assertEquals((long[])keys2, (long[])keys);
        Memory hqsskMem = Memory.wrap((byte[])hqssk.toByteArray());
        DirectArrayOfDoublesQuickSelectSketchR dqssk = (DirectArrayOfDoublesQuickSelectSketchR)ArrayOfDoublesSketch.wrap((Memory)hqsskMem, (long)9001L);
        double[][] values3 = dqssk.getValues();
        double[] values1d3 = dqssk.getValuesAsOneDimension();
        long[] keys3 = dqssk.getKeys();
        Assert.assertEquals((Object[])values3, (Object[])values);
        Assert.assertEquals((double[])values1d3, (double[])values1d);
        Assert.assertEquals((long[])keys3, (long[])keys);
        Memory hcskMem = Memory.wrap((byte[])hcsk.toByteArray());
        DirectArrayOfDoublesCompactSketch dcsk2 = (DirectArrayOfDoublesCompactSketch)ArrayOfDoublesSketch.wrap((Memory)hcskMem, (long)9001L);
        double[][] values4 = dqssk.getValues();
        double[] values1d4 = dqssk.getValuesAsOneDimension();
        long[] keys4 = dqssk.getKeys();
        Assert.assertEquals((Object[])values4, (Object[])values);
        Assert.assertEquals((double[])values1d4, (double[])values1d);
        Assert.assertEquals((long[])keys4, (long[])keys);
    }
}

