/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int LG_MAX_MAP_SIZE_BYTE = 3;
    static final int LG_CUR_MAP_SIZE_BYTE = 4;
    static final int FLAGS_BYTE = 5;
    static final int SER_DE_ID_SHORT = 6;
    static final int ACTIVE_ITEMS_INT = 8;
    static final int STREAMLENGTH_LONG = 16;
    static final int OFFSET_LONG = 24;
    static final int EMPTY_FLAG_MASK = 5;
    static final int SER_VER = 1;

    private PreambleUtil() {
    }

    public static String preambleToString(MemorySegment srcSeg) {
        long pre0 = PreambleUtil.checkPreambleSize(srcSeg);
        int preLongs = PreambleUtil.extractPreLongs(pre0);
        int serVer = PreambleUtil.extractSerVer(pre0);
        Family family = Family.idToFamily(PreambleUtil.extractFamilyID(pre0));
        int lgMaxMapSize = PreambleUtil.extractLgMaxMapSize(pre0);
        int lgCurMapSize = PreambleUtil.extractLgCurMapSize(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean empty = (flags & 5) > 0;
        int maxMapSize = 1 << lgMaxMapSize;
        int curMapSize = 1 << lgCurMapSize;
        int maxPreLongs = Family.FREQUENCY.getMaxPreLongs();
        int activeItems = 0;
        long streamLength = 0L;
        long offset = 0L;
        if (preLongs == maxPreLongs) {
            long[] preArr = new long[preLongs];
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_LONG_UNALIGNED, 0L, preArr, 0, preLongs);
            activeItems = PreambleUtil.extractActiveItems(preArr[1]);
            streamLength = preArr[2];
            offset = preArr[3];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### FREQUENCY SKETCH PREAMBLE SUMMARY:").append(Util.LS).append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS).append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS).append("Byte  2: Family               : ").append(family.toString()).append(Util.LS).append("Byte  3: MaxMapSize           : ").append(maxMapSize).append(Util.LS).append("Byte  4: CurMapSize           : ").append(curMapSize).append(Util.LS).append("Byte  5: Flags Field          : ").append(flagsStr).append(Util.LS).append("  EMPTY                       : ").append(empty).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
        } else {
            sb.append("Bytes 8-11 : ActiveItems      : ").append(activeItems).append(Util.LS);
            sb.append("Bytes 16-23: StreamLength     : ").append(streamLength).append(Util.LS).append("Bytes 24-31: Offset           : ").append(offset).append(Util.LS);
        }
        sb.append("Preamble Bytes                : ").append(preLongs * 8).append(Util.LS);
        sb.append("TOTAL Sketch Bytes            : ").append(preLongs + activeItems * 2 << 3).append(Util.LS).append("### END FREQUENCY SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(long pre0) {
        long mask = 63L;
        return (int)(pre0 & 0x3FL);
    }

    static int extractSerVer(long pre0) {
        int shift = 8;
        long mask = 255L;
        return (int)(pre0 >>> 8 & 0xFFL);
    }

    static int extractFamilyID(long pre0) {
        int shift = 16;
        long mask = 255L;
        return (int)(pre0 >>> 16 & 0xFFL);
    }

    static int extractLgMaxMapSize(long pre0) {
        int shift = 24;
        long mask = 255L;
        return (int)(pre0 >>> 24 & 0xFFL);
    }

    static int extractLgCurMapSize(long pre0) {
        int shift = 32;
        long mask = 255L;
        return (int)(pre0 >>> 32 & 0xFFL);
    }

    static int extractFlags(long pre0) {
        int shift = 40;
        long mask = 255L;
        return (int)(pre0 >>> 40 & 0xFFL);
    }

    static int extractActiveItems(long pre1) {
        long mask = 0xFFFFFFFFL;
        return (int)(pre1 & 0xFFFFFFFFL);
    }

    static long insertPreLongs(int preLongs, long pre0) {
        long mask = 63L;
        return (long)preLongs & 0x3FL | 0xFFFFFFFFFFFFFFC0L & pre0;
    }

    static long insertSerVer(int serVer, long pre0) {
        int shift = 8;
        long mask = 255L;
        return ((long)serVer & 0xFFL) << 8 | 0xFFFFFFFFFFFF00FFL & pre0;
    }

    static long insertFamilyID(int familyID, long pre0) {
        int shift = 16;
        long mask = 255L;
        return ((long)familyID & 0xFFL) << 16 | 0xFFFFFFFFFF00FFFFL & pre0;
    }

    static long insertLgMaxMapSize(int lgMaxMapSize, long pre0) {
        int shift = 24;
        long mask = 255L;
        return ((long)lgMaxMapSize & 0xFFL) << 24 | 0xFFFFFFFF00FFFFFFL & pre0;
    }

    static long insertLgCurMapSize(int lgCurMapSize, long pre0) {
        int shift = 32;
        long mask = 255L;
        return ((long)lgCurMapSize & 0xFFL) << 32 | 0xFFFFFF00FFFFFFFFL & pre0;
    }

    static long insertFlags(int flags, long pre0) {
        int shift = 40;
        long mask = 255L;
        return ((long)flags & 0xFFL) << 40 | 0xFFFF00FFFFFFFFFFL & pre0;
    }

    static long insertActiveItems(int activeItems, long pre1) {
        long mask = 0xFFFFFFFFL;
        return (long)activeItems & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & pre1;
    }

    static long checkPreambleSize(MemorySegment seg) {
        long pre0;
        int preLongs;
        int required;
        long cap = seg.byteSize();
        if (cap < 8L) {
            PreambleUtil.throwNotBigEnough(cap, 8);
        }
        if (cap < (long)(required = Math.max((preLongs = (int)((pre0 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 0L)) & 0x3FL)) << 3, 8))) {
            PreambleUtil.throwNotBigEnough(cap, required);
        }
        return pre0;
    }

    private static void throwNotBigEnough(long cap, int required) {
        throw new SketchesArgumentException("Possible Corruption: Size of byte array or MemorySegment not large enough for Preamble: Size: " + cap + ", Required: " + required);
    }
}

