/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllSketch;

final class KllPreambleUtil {
    static final int PREAMBLE_INTS_BYTE_ADR = 0;
    static final int SER_VER_BYTE_ADR = 1;
    static final int FAMILY_BYTE_ADR = 2;
    static final int FLAGS_BYTE_ADR = 3;
    static final int K_SHORT_ADR = 4;
    static final int M_BYTE_ADR = 6;
    static final int DATA_START_ADR_SINGLE_ITEM = 8;
    static final int N_LONG_ADR = 8;
    static final int MIN_K_SHORT_ADR = 16;
    static final int NUM_LEVELS_BYTE_ADR = 18;
    static final int DATA_START_ADR = 20;
    static final byte SERIAL_VERSION_EMPTY_FULL = 1;
    static final byte SERIAL_VERSION_SINGLE = 2;
    static final byte SERIAL_VERSION_UPDATABLE = 3;
    static final byte PREAMBLE_INTS_EMPTY_SINGLE = 2;
    static final byte PREAMBLE_INTS_FULL = 5;
    static final byte KLL_FAMILY = 15;
    static final int EMPTY_BIT_MASK = 1;
    static final int LEVEL_ZERO_SORTED_BIT_MASK = 2;
    static final int SINGLE_ITEM_BIT_MASK = 4;

    private KllPreambleUtil() {
    }

    static String toString(byte[] byteArr, KllSketch.SketchType sketchType, boolean includeData) {
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return KllPreambleUtil.toString(seg, sketchType, includeData, null);
    }

    static String toString(byte[] byteArr, KllSketch.SketchType sketchType, boolean includeData, ArrayOfItemsSerDe<?> serDe) {
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return KllPreambleUtil.toString(seg, sketchType, includeData, serDe);
    }

    static String toString(MemorySegment seg, KllSketch.SketchType sketchType, boolean includeData) {
        return KllPreambleUtil.toString(seg, sketchType, includeData, null);
    }

    static <T> String toString(MemorySegment seg, KllSketch.SketchType sketchType, boolean includeData, ArrayOfItemsSerDe<T> serDe) {
        if (sketchType == KllSketch.SketchType.KLL_ITEMS_SKETCH) {
            Objects.requireNonNull(serDe, "SerDe parameter must not be null for ITEMS_SKETCH.");
        }
        KllMemorySegmentValidate segVal = new KllMemorySegmentValidate(seg, sketchType, serDe);
        KllSketch.SketchStructure myStructure = segVal.sketchStructure;
        int flags = segVal.flags & 0xFF;
        String flagsStr = flags + ", 0x" + Integer.toHexString(flags) + ", " + Util.zeroPad(Integer.toBinaryString(flags), 8);
        int preInts = segVal.preInts;
        boolean emptyFlag = segVal.emptyFlag;
        int sketchBytes = segVal.sketchBytes;
        int typeBytes = sketchType.getBytes();
        int familyID = KllPreambleUtil.getMemorySegmentFamilyID(seg);
        String famName = Family.idToFamily(familyID).toString();
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### KLL SKETCH MEMORY SUMMARY:").append(Util.LS);
        sb.append("Sketch Type                          : ").append(sketchType.toString()).append(Util.LS);
        sb.append("SketchStructure                      : ").append(myStructure.toString()).append(Util.LS);
        sb.append("Byte   0       : Preamble Ints       : ").append(preInts).append(Util.LS);
        sb.append("Byte   1       : SerVer              : ").append(segVal.serVer).append(Util.LS);
        sb.append("Byte   2       : FamilyID            : ").append(segVal.familyID).append(Util.LS);
        sb.append("               : FamilyName          : ").append(famName).append(Util.LS);
        sb.append("Byte   3       : Flags Field         : ").append(flagsStr).append(Util.LS);
        sb.append("            Bit: Flag Name           : ").append(Util.LS);
        sb.append("              0: EMPTY               : ").append(emptyFlag).append(Util.LS);
        sb.append("              1: LEVEL_ZERO_SORTED   : ").append(segVal.level0SortedFlag).append(Util.LS);
        sb.append("Bytes  4-5     : K                   : ").append(segVal.k).append(Util.LS);
        sb.append("Byte   6       : Min Level Cap, M    : ").append(segVal.m).append(Util.LS);
        sb.append("Byte   7       : (Reserved)          : ").append(Util.LS);
        long n = segVal.n;
        int minK = segVal.minK;
        int numLevels = segVal.numLevels;
        int[] levelsArr = segVal.levelsArr;
        int retainedItems = levelsArr[numLevels] - levelsArr[0];
        if (myStructure == KllSketch.SketchStructure.COMPACT_FULL || myStructure == KllSketch.SketchStructure.UPDATABLE) {
            sb.append("Bytes  8-15    : N                   : ").append(n).append(Util.LS);
            sb.append("Bytes 16-17    : MinK                : ").append(minK).append(Util.LS);
            sb.append("Byte  18       : NumLevels           : ").append(numLevels).append(Util.LS);
        } else {
            sb.append("Assumed        : N                   : ").append(n).append(Util.LS);
            sb.append("Assumed        : MinK                : ").append(minK).append(Util.LS);
            sb.append("Assumed        : NumLevels           : ").append(numLevels).append(Util.LS);
        }
        sb.append("PreambleBytes                        : ").append(preInts * 4).append(Util.LS);
        sb.append("Sketch Bytes                         : ").append(sketchBytes).append(Util.LS);
        sb.append("MemorySegment Capacity Bytes                : ").append(seg.byteSize()).append(Util.LS);
        sb.append("### END KLL Sketch MemorySegment Summary").append(Util.LS);
        if (includeData) {
            sb.append(Util.LS);
            sb.append("### START KLL DATA:").append(Util.LS);
            int offsetBytes = 0;
            if (myStructure == KllSketch.SketchStructure.UPDATABLE) {
                sb.append("LEVELS ARR:").append(Util.LS);
                offsetBytes = 20;
                for (int i = 0; i < numLevels + 1; ++i) {
                    sb.append(i + ", " + seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    offsetBytes += 4;
                }
                sb.append("MIN/MAX:").append(Util.LS);
                if (sketchType == KllSketch.SketchType.KLL_DOUBLES_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    sb.append(seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)(offsetBytes += typeBytes))).append(Util.LS);
                    offsetBytes += typeBytes;
                } else if (sketchType == KllSketch.SketchType.KLL_FLOATS_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    sb.append(seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offsetBytes += typeBytes))).append(Util.LS);
                    offsetBytes += typeBytes;
                } else if (sketchType == KllSketch.SketchType.KLL_LONGS_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    sb.append(seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)(offsetBytes += typeBytes))).append(Util.LS);
                    offsetBytes += typeBytes;
                } else {
                    sb.append("<<<Updatable Structure is not suppported by KllItemsSketch>>>").append(Util.LS);
                }
                sb.append("ALL DATA (including free space)").append(Util.LS);
                int itemsSpace = (sketchBytes - offsetBytes) / typeBytes;
                if (sketchType == KllSketch.SketchType.KLL_DOUBLES_SKETCH) {
                    for (int i = 0; i < itemsSpace; ++i) {
                        sb.append(i + ", " + seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                        offsetBytes += typeBytes;
                    }
                } else if (sketchType == KllSketch.SketchType.KLL_FLOATS_SKETCH) {
                    for (int i = 0; i < itemsSpace; ++i) {
                        sb.append(seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                        offsetBytes += typeBytes;
                    }
                } else if (sketchType == KllSketch.SketchType.KLL_LONGS_SKETCH) {
                    for (int i = 0; i < itemsSpace; ++i) {
                        sb.append(seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                        offsetBytes += typeBytes;
                    }
                } else {
                    sb.append("<<<Updatable Structure is not suppported by KllItemsSketch>>>").append(Util.LS);
                }
            } else if (myStructure == KllSketch.SketchStructure.COMPACT_FULL) {
                int j;
                sb.append("LEVELS ARR:").append(Util.LS);
                offsetBytes = 20;
                for (j = 0; j < numLevels; ++j) {
                    sb.append(j + ", " + seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    offsetBytes += 4;
                }
                sb.append(j + ", " + levelsArr[numLevels]);
                sb.append(" (Top level of Levels Array is absent in MemorySegment)").append(Util.LS);
                sb.append("MIN/MAX:").append(Util.LS);
                if (sketchType == KllSketch.SketchType.KLL_DOUBLES_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    sb.append(seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)(offsetBytes += typeBytes))).append(Util.LS);
                    offsetBytes += typeBytes;
                } else if (sketchType == KllSketch.SketchType.KLL_FLOATS_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    sb.append(seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offsetBytes += typeBytes))).append(Util.LS);
                    offsetBytes += typeBytes;
                } else if (sketchType == KllSketch.SketchType.KLL_LONGS_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                    sb.append(seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)(offsetBytes += typeBytes))).append(Util.LS);
                    offsetBytes += typeBytes;
                } else {
                    sb.append(serDe.deserializeFromMemorySegment(seg, offsetBytes, 1)[0]).append(Util.LS);
                    offsetBytes += serDe.sizeOf(seg, offsetBytes, 1);
                    sb.append(serDe.deserializeFromMemorySegment(seg, offsetBytes, 1)[0]).append(Util.LS);
                    offsetBytes += serDe.sizeOf(seg, offsetBytes, 1);
                }
                sb.append("RETAINED DATA").append(Util.LS);
                int itemSpace = (sketchBytes - offsetBytes) / (typeBytes == 0 ? 1 : typeBytes);
                if (sketchType == KllSketch.SketchType.KLL_DOUBLES_SKETCH) {
                    for (int i = 0; i < itemSpace; ++i) {
                        sb.append(i + ", " + seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                        offsetBytes += typeBytes;
                    }
                } else if (sketchType == KllSketch.SketchType.KLL_FLOATS_SKETCH) {
                    for (int i = 0; i < itemSpace; ++i) {
                        sb.append(i + ", " + seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                        offsetBytes += typeBytes;
                    }
                } else if (sketchType == KllSketch.SketchType.KLL_LONGS_SKETCH) {
                    for (int i = 0; i < itemSpace; ++i) {
                        sb.append(i + ", " + seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offsetBytes)).append(Util.LS);
                        offsetBytes += typeBytes;
                    }
                } else {
                    T[] itemsArr = serDe.deserializeFromMemorySegment(seg, offsetBytes, retainedItems);
                    for (int i = 0; i < itemsArr.length; ++i) {
                        sb.append(i + ", " + serDe.toString(itemsArr[i])).append(Util.LS);
                    }
                }
            } else if (myStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
                sb.append("SINGLE ITEM DATUM: ");
                if (sketchType == KllSketch.SketchType.KLL_DOUBLES_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 8L)).append(Util.LS);
                } else if (sketchType == KllSketch.SketchType.KLL_FLOATS_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 8L)).append(Util.LS);
                } else if (sketchType == KllSketch.SketchType.KLL_LONGS_SKETCH) {
                    sb.append(seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L)).append(Util.LS);
                } else {
                    sb.append(serDe.deserializeFromMemorySegment(seg, 8L, 1)[0]).append(Util.LS);
                }
            } else {
                sb.append("EMPTY, NO DATA").append(Util.LS);
            }
            sb.append("### END KLL DATA:").append(Util.LS);
        }
        return sb.toString();
    }

    static int getMemorySegmentPreInts(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
    }

    static int getMemorySegmentSerVer(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 1L) & 0xFF;
    }

    static KllSketch.SketchStructure getMemorySegmentSketchStructure(MemorySegment seg) {
        int preInts = KllPreambleUtil.getMemorySegmentPreInts(seg);
        int serVer = KllPreambleUtil.getMemorySegmentSerVer(seg);
        return KllSketch.SketchStructure.getSketchStructure(preInts, serVer);
    }

    static int getMemorySegmentFamilyID(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 2L) & 0xFF;
    }

    static int getMemorySegmentFlags(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 3L) & 0xFF;
    }

    static boolean getMemorySegmentEmptyFlag(MemorySegment seg) {
        return (KllPreambleUtil.getMemorySegmentFlags(seg) & 1) != 0;
    }

    static boolean getMemorySegmentLevelZeroSortedFlag(MemorySegment seg) {
        return (KllPreambleUtil.getMemorySegmentFlags(seg) & 2) != 0;
    }

    static int getMemorySegmentK(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 4L) & 0xFFFF;
    }

    static int getMemorySegmentM(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 6L) & 0xFF;
    }

    static long getMemorySegmentN(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    static int getMemorySegmentMinK(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 16L) & 0xFFFF;
    }

    static int getMemorySegmentNumLevels(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 18L) & 0xFF;
    }

    static void setMemorySegmentPreInts(MemorySegment wseg, int numPreInts) {
        wseg.set(ValueLayout.JAVA_BYTE, 0L, (byte)numPreInts);
    }

    static void setMemorySegmentSerVer(MemorySegment wseg, int serVer) {
        wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)serVer);
    }

    static void setMemorySegmentFamilyID(MemorySegment wseg, int famId) {
        wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)famId);
    }

    static void setMemorySegmentFlags(MemorySegment wseg, int flags) {
        wseg.set(ValueLayout.JAVA_BYTE, 3L, (byte)flags);
    }

    static void setMemorySegmentEmptyFlag(MemorySegment wseg, boolean empty) {
        int flags = KllPreambleUtil.getMemorySegmentFlags(wseg);
        KllPreambleUtil.setMemorySegmentFlags(wseg, empty ? flags | 1 : flags & 0xFFFFFFFE);
    }

    static void setMemorySegmentLevelZeroSortedFlag(MemorySegment wseg, boolean levelZeroSorted) {
        int flags = KllPreambleUtil.getMemorySegmentFlags(wseg);
        KllPreambleUtil.setMemorySegmentFlags(wseg, levelZeroSorted ? flags | 2 : flags & 0xFFFFFFFD);
    }

    static void setMemorySegmentK(MemorySegment wseg, int segK) {
        wseg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 4L, (short)segK);
    }

    static void setMemorySegmentM(MemorySegment wseg, int segM) {
        wseg.set(ValueLayout.JAVA_BYTE, 6L, (byte)segM);
    }

    static void setMemorySegmentN(MemorySegment wseg, long segN) {
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, segN);
    }

    static void setMemorySegmentMinK(MemorySegment wseg, int segMinK) {
        wseg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 16L, (short)segMinK);
    }

    static void setMemorySegmentNumLevels(MemorySegment wseg, int segNumLevels) {
        wseg.set(ValueLayout.JAVA_BYTE, 18L, (byte)segNumLevels);
    }
}

