/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AllocateDirectMemoryTest {
    @Test
    public void simpleAllocateDirect() {
        int longs = 32;
        WritableMemory wMem2 = null;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wMem;
            wMem2 = wMem = WritableMemory.allocateDirect((long)(longs << 3), (Arena)arena);
            for (int i = 0; i < longs; ++i) {
                wMem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)wMem.getLong((long)(i << 3)), (long)i);
            }
            Assert.assertTrue((boolean)wMem.isAlive());
        }
        if (wMem2 != null) {
            Assert.assertFalse((boolean)wMem2.isAlive());
        }
    }

    @Test
    public void checkDefaultMemoryRequestServer() {
        boolean oneArena = false;
        boolean offHeap = false;
        this.checkDefaultMemoryRequestServerVariations(false, false, false);
        this.checkDefaultMemoryRequestServerVariations(false, false, true);
        this.checkDefaultMemoryRequestServerVariations(false, true, false);
        this.checkDefaultMemoryRequestServerVariations(false, true, true);
        this.checkDefaultMemoryRequestServerVariations(true, false, false);
        this.checkDefaultMemoryRequestServerVariations(true, false, true);
        this.checkDefaultMemoryRequestServerVariations(true, true, false);
        this.checkDefaultMemoryRequestServerVariations(true, true, true);
    }

    private void checkDefaultMemoryRequestServerVariations(boolean origArena, boolean oneArena, boolean offHeap) {
        int longs1 = 32;
        int bytes1 = longs1 << 3;
        if (origArena) {
            WritableMemory newWmem;
            WritableMemory origWmem;
            DefaultMemoryRequestServer dmrs = new DefaultMemoryRequestServer(8L, ByteOrder.nativeOrder(), oneArena, offHeap);
            try (Arena arena = Arena.ofConfined();){
                origWmem = WritableMemory.allocateDirect((long)bytes1, (long)8L, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)dmrs, (Arena)arena);
                Assert.assertTrue((boolean)origWmem.isDirect());
                for (int i = 0; i < longs1; ++i) {
                    origWmem.putLong((long)(i << 3), (long)i);
                    Assert.assertEquals((long)origWmem.getLong((long)(i << 3)), (long)i);
                }
                AllocateDirectMemoryTest.println(origWmem.toString("Test", 0L, longs1 << 3, true));
                int longs2 = 2 * longs1;
                int bytes2 = longs2 << 3;
                MemoryRequestServer myMemReqSvr = origWmem.getMemoryRequestServer();
                newWmem = myMemReqSvr.request(origWmem, (long)bytes2);
                Assert.assertTrue((boolean)(offHeap && origArena ? newWmem.isDirect() : newWmem.isHeap()));
                for (int i = 0; i < longs2; ++i) {
                    newWmem.putLong((long)(i << 3), (long)i);
                    Assert.assertEquals((long)newWmem.getLong((long)(i << 3)), (long)i);
                }
                AllocateDirectMemoryTest.println(newWmem.toString("Test", 0L, longs2 << 3, true));
                if (oneArena && offHeap) {
                    Assert.assertTrue((newWmem.getArena() == origWmem.getArena() && origWmem != null ? 1 : 0) != 0);
                }
                if (oneArena && !offHeap) {
                    Assert.assertTrue((newWmem.getArena() == null && origWmem != null ? 1 : 0) != 0);
                }
                if (!oneArena && offHeap) {
                    Assert.assertTrue((newWmem.getArena() != origWmem.getArena() && origWmem != null ? 1 : 0) != 0);
                }
            }
            Assert.assertFalse((boolean)origWmem.getArena().scope().isAlive());
            if (!oneArena && offHeap) {
                newWmem.getArena().close();
                Assert.assertFalse((boolean)newWmem.getArena().scope().isAlive());
            }
        } else {
            DefaultMemoryRequestServer dmrs = new DefaultMemoryRequestServer(8L, ByteOrder.nativeOrder(), oneArena, offHeap);
            WritableMemory origWmem = WritableMemory.allocate((int)bytes1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)dmrs);
            for (int i = 0; i < longs1; ++i) {
                origWmem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)origWmem.getLong((long)(i << 3)), (long)i);
            }
            AllocateDirectMemoryTest.println(origWmem.toString("Test", 0L, longs1 << 3, true));
            int longs2 = 2 * longs1;
            int bytes2 = longs2 << 3;
            MemoryRequestServer myMemReqSvr = origWmem.getMemoryRequestServer();
            WritableMemory newWmem = myMemReqSvr.request(origWmem, (long)bytes2);
            Assert.assertTrue((boolean)(offHeap && origArena ? newWmem.isDirect() : newWmem.isHeap()));
            for (int i = 0; i < longs2; ++i) {
                newWmem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)newWmem.getLong((long)(i << 3)), (long)i);
            }
            AllocateDirectMemoryTest.println(newWmem.toString("Test", 0L, longs2 << 3, true));
        }
    }

    @Test
    public void checkNonNativeDirect() {
        MemoryRequestServer myMemReqSvr = Resource.defaultMemReqSvr;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)128L, (long)8L, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER, (MemoryRequestServer)myMemReqSvr, (Arena)arena);
            wmem.putChar(0L, '\u0001');
            Assert.assertEquals((byte)wmem.getByte(1L), (byte)1);
        }
    }

    @Test
    public void checkExplicitCloseNoTWR() {
        long cap = 128L;
        Arena arena = Arena.ofConfined();
        WritableMemory wmem = WritableMemory.allocateDirect((long)128L, (Arena)arena);
        arena.close();
        Assert.assertFalse((boolean)wmem.isAlive());
    }

    @Test
    public void printlnTest() {
        AllocateDirectMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

