/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkCompare() {
        byte[] arr1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] arr2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        MemorySegment seg1 = MemorySegment.ofArray(arr1);
        MemorySegment seg2 = MemorySegment.ofArray(arr2);
        int c = ResourceImpl.compare((MemorySegment)seg1, (long)0L, (long)9L, (MemorySegment)seg2, (long)0L, (long)8L);
        Assert.assertEquals((int)c, (int)1);
    }

    @Test
    public void checkCompareToDirect() throws Exception {
        byte[] arr1 = new byte[]{0, 1, 2, 3};
        byte[] arr2 = new byte[]{0, 1, 2, 4};
        byte[] arr3 = new byte[]{0, 1, 2, 3, 4};
        try (Arena arena = Arena.ofConfined();){
            WritableMemory mem1 = WritableMemory.allocateDirect((long)4L, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableMemory mem2 = WritableMemory.allocateDirect((long)4L, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableMemory mem3 = WritableMemory.allocateDirect((long)5L, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            mem1.putByteArray(0L, arr1, 0, 4);
            mem2.putByteArray(0L, arr2, 0, 4);
            mem3.putByteArray(0L, arr3, 0, 5);
            int comp = mem1.compareTo(0L, 3L, (Resource)mem2, 0L, 3L);
            Assert.assertEquals((int)comp, (int)0);
            comp = mem1.compareTo(0L, 4L, (Resource)mem2, 0L, 4L);
            Assert.assertEquals((int)comp, (int)-1);
            comp = mem2.compareTo(0L, 4L, (Resource)mem1, 0L, 4L);
            Assert.assertEquals((int)comp, (int)1);
            comp = mem1.compareTo(0L, 4L, (Resource)mem3, 0L, 5L);
            Assert.assertEquals((int)comp, (int)-1);
            comp = mem3.compareTo(0L, 5L, (Resource)mem1, 0L, 4L);
            Assert.assertEquals((int)comp, (int)1);
        }
    }

    @Test
    public void checkCompareToHeap() {
        byte[] arr1 = new byte[]{0, 1, 2, 3};
        byte[] arr2 = new byte[]{0, 1, 2, 4};
        byte[] arr3 = new byte[]{0, 1, 2, 3, 4};
        Memory mem1 = Memory.wrap((byte[])arr1);
        Memory mem2 = Memory.wrap((byte[])arr2);
        Memory mem3 = Memory.wrap((byte[])arr3);
        Memory mem4 = Memory.wrap((byte[])arr3);
        int comp = mem1.compareTo(0L, 3L, (Resource)mem2, 0L, 3L);
        Assert.assertEquals((int)comp, (int)0);
        comp = mem1.compareTo(0L, 4L, (Resource)mem2, 0L, 4L);
        Assert.assertEquals((int)comp, (int)-1);
        comp = mem2.compareTo(0L, 4L, (Resource)mem1, 0L, 4L);
        Assert.assertEquals((int)comp, (int)1);
        comp = mem1.compareTo(0L, 4L, (Resource)mem3, 0L, 5L);
        Assert.assertEquals((int)comp, (int)-1);
        comp = mem3.compareTo(0L, 5L, (Resource)mem1, 0L, 4L);
        Assert.assertEquals((int)comp, (int)1);
        comp = mem3.compareTo(0L, 5L, (Resource)mem4, 0L, 5L);
        Assert.assertEquals((int)comp, (int)0);
        comp = mem3.compareTo(0L, 4L, (Resource)mem4, 1L, 4L);
        Assert.assertEquals((int)comp, (int)-1);
        ResourceImpl.checkBounds((long)0L, (long)5L, (long)mem3.getCapacity());
    }

    @Test
    public void checkCompareToSamePrefix() {
        WritableMemory wmem = WritableMemory.allocate((int)3);
        wmem.clear();
        Assert.assertEquals((int)wmem.compareTo(0L, 1L, (Resource)wmem, 0L, 2L), (int)-1);
        Assert.assertEquals((int)wmem.compareTo(1L, 1L, (Resource)wmem, 1L, 1L), (int)0);
        Assert.assertEquals((int)wmem.compareTo(1L, 2L, (Resource)wmem, 1L, 1L), (int)1);
    }

    @Test
    public void checkGetRelativeOffset() {
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)1024L, (Arena)arena);
            WritableMemory reg = wmem.writableRegion(512L, 256L);
            long off = wmem.getRelativeOffset((Resource)reg);
            Assert.assertEquals((long)off, (long)512L);
        }
    }

    @Test
    public void checkIsByteOrderCompatible() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        Assert.assertTrue((boolean)wmem.isByteOrderCompatible(ByteOrder.nativeOrder()));
    }

    @Test
    public void checkIsSameResource() {
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)1024L, (Arena)arena);
            WritableMemory reg = wmem.writableRegion(0L, 1024L);
            Assert.assertTrue((boolean)wmem.isSameResource((Resource)reg));
        }
    }

    @Test
    public void checkNativeOverlap() {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment par = arena.allocate(100L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 40L, 60L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 20L, 40L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)20L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 10L, 30L)), (long)10L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 10L, 30L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)-10L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 20L, 40L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 0L), (MemorySegment)ResourceTest.getSeg(par, 0L, 0L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 60L, 80L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 40L, 60L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 30L, 50L)), (long)10L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 20L, 40L)), (long)20L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 10L, 30L)), (long)20L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)20L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 10L, 50L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)-10L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 20L, 60L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 40L, 80L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 40L, 80L), (MemorySegment)ResourceTest.getSeg(par, 0L, 0L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 60L, 80L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 40L, 60L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 30L, 50L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)-10L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 20L, 40L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)-20L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 10L, 30L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)-20L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)20L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 10L, 50L)), (long)10L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 20L, 60L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 40L, 80L)), (long)0L);
            Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 0L), (MemorySegment)ResourceTest.getSeg(par, 40L, 80L)), (long)0L);
        }
    }

    private static MemorySegment getSeg(MemorySegment parent, long left, long right) {
        return parent.asSlice(left, right - left);
    }

    @Test
    public void checkNotEqualTo() {
        byte[] arr1 = new byte[8];
        Memory mem = Memory.wrap((byte[])arr1);
        byte[] arr2 = new byte[8];
        arr2[7] = 1;
        Memory mem2 = Memory.wrap((byte[])arr2);
        Assert.assertFalse((boolean)mem.equalTo(0L, (Resource)mem2, 0L, 8L));
    }

    @Test
    public void checkParseJavaVersion() {
        try {
            ResourceImpl.parseJavaVersion((String)"15_1");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ResourceImpl.parseJavaVersion((String)"20");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ResourceImpl.parseJavaVersion((String)"21");
        ResourceImpl.parseJavaVersion((String)"22");
    }

    @Test
    public void checkToHexString() {
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[16]);
        ResourceTest.println(mem.toString("baseMem", 0L, 16, true));
        for (int i = 0; i < 16; ++i) {
            mem.putByte((long)i, (byte)i);
        }
        Buffer buf = mem.asBuffer();
        ResourceTest.println(buf.toString("buffer", 0L, 16, true));
    }

    @Test
    public void checkToMemorySegment() {
        int len = 0;
        WritableMemory mem = WritableMemory.allocate((int)len);
        MemorySegment seg = mem.toMemorySegment(null, 8L);
        Assert.assertEquals((long)seg.byteSize(), (long)len);
        len = 104;
        mem = WritableMemory.allocate((int)len);
        seg = mem.toMemorySegment(null, 8L);
        Assert.assertEquals((long)seg.byteSize(), (long)len);
        len = 52;
        mem = WritableMemory.allocate((int)len);
        seg = mem.toMemorySegment(null, 8L);
        Assert.assertEquals((long)seg.byteSize(), (long)len);
        len = 26;
        mem = WritableMemory.allocate((int)len);
        seg = mem.toMemorySegment(null, 8L);
        Assert.assertEquals((long)seg.byteSize(), (long)len);
        len = 13;
        mem = WritableMemory.allocate((int)len);
        seg = mem.toMemorySegment(null, 8L);
        Assert.assertEquals((long)seg.byteSize(), (long)len);
    }

    @Test
    public void checkTypeDecode() {
        for (int i = 0; i < 256; ++i) {
            String str = ResourceImpl.typeDecode((int)i);
            ResourceTest.println(i + "\t" + str);
        }
    }

    @Test
    public void checkXxHash64() {
        WritableMemory mem = WritableMemory.allocate((int)8);
        long out = mem.xxHash64(mem.getLong(0L), 1L);
        Assert.assertTrue((out != 0L ? 1 : 0) != 0);
    }

    @Test
    public void checkMismatch() {
        byte[] arr1 = new byte[]{1, 2, 3, 4};
        byte[] arr2 = new byte[]{1, 2, 3, 4};
        byte[] arr3 = new byte[]{1, 2, 3, 4, 5};
        Memory mem1 = Memory.wrap((byte[])arr1);
        Memory mem2 = Memory.wrap((byte[])arr2);
        Memory mem3 = Memory.wrap((byte[])arr3);
        Assert.assertEquals((long)mem1.mismatch((Resource)mem2), (long)-1L);
        Assert.assertEquals((long)mem1.mismatch((Resource)mem3), (long)4L);
        byte[] arr4 = new byte[]{9, 9, 1, 2, 3, 4, 9, 9};
        byte[] arr5 = new byte[]{8, 8, 8, 1, 2, 3, 4, 8};
        byte[] arr6 = new byte[]{8, 8, 8, 1, 2, 3, 4, 5};
        Memory mem4 = Memory.wrap((byte[])arr4);
        Memory mem5 = Memory.wrap((byte[])arr5);
        Memory mem6 = Memory.wrap((byte[])arr6);
        Assert.assertEquals((long)mem4.mismatch((Resource)mem4, 2L, 6L, (Resource)mem5, 3L, 7L), (long)-1L);
        Assert.assertEquals((long)mem4.mismatch((Resource)mem4, 2L, 7L, (Resource)mem6, 3L, 8L), (long)4L);
    }

    @Test
    public void printlnTest() {
        ResourceTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

