/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_6
extends UpgradeChange {
    private static final String BAD_SYNTAX = "42X01";
    private static final String TABLE_DOES_NOT_EXIST = "42X05";
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String QUERY_4215 = "select r.grantor\nfrom sys.sysroutineperms r, sys.sysaliases a\nwhere r.aliasid = a.aliasid\nand a.alias = 'SYSCS_INPLACE_COMPRESS_TABLE'\n";
    private static final String CREATE_TYPE_DDL = "create type fooType external name 'mypackage.foo' language java\n";
    private static final String DROP_TYPE_DDL = "drop type fooType restrict\n";
    static final String HASH_ALGORITHM_PROPERTY = "derby.authentication.builtin.algorithm";

    public Changes10_6(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        BaseTestSuite suite = new BaseTestSuite("Upgrade test for 10.6");
        suite.addTestSuite(Changes10_6.class);
        return new SupportFilesSetup((Test)suite);
    }

    public void testSetXplainStyleProcedure() throws SQLException {
        String[] xplainProcedures = new String[]{"call SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA('XPLAIN')", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA('')", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(1)", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(0)", "values SYSCS_UTIL.SYSCS_GET_XPLAIN_SCHEMA()", "values SYSCS_UTIL.SYSCS_GET_XPLAIN_MODE()"};
        switch (this.getPhase()) {
            case 1: 
            case 2: {
                Statement s = this.createStatement();
                for (int i = 0; i < xplainProcedures.length; ++i) {
                    Changes10_6.assertStatementError("42Y03", s, xplainProcedures[i]);
                }
                s.close();
                break;
            }
            case 3: {
                Statement s = this.createStatement();
                for (int i = 0; i < xplainProcedures.length; ++i) {
                    s.execute(xplainProcedures[i]);
                }
                s.close();
            }
        }
    }

    public void testCLOBGETSUBSTRING() throws Exception {
        Version initialVersion = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        Version firstVersionHavingThisFunction = new Version(10, 3, 0, 0);
        Version firstVersionHavingCorrectReturnType = new Version(10, 5, 0, 0);
        int wrongLength = 32672;
        int correctLength = 10890;
        boolean hasFunction = initialVersion.compareTo(firstVersionHavingThisFunction) >= 0;
        boolean hasCorrectReturnType = initialVersion.compareTo(firstVersionHavingCorrectReturnType) >= 0;
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select a.aliasinfo\nfrom sys.sysschemas s, sys.sysaliases a\nwhere s.schemaid = a.schemaid\nand s.schemaname = 'SYSIBM'\nand alias = 'CLOBGETSUBSTRING'\n");
        rs.next();
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                if (!hasFunction) break;
                Object returnType = this.getTypeDescriptor(rs.getObject(1));
                int actualJdbcType = this.getJDBCTypeId(returnType);
                int actualLength = this.getMaximumWidth(returnType);
                int expectedLength = hasCorrectReturnType ? correctLength : wrongLength;
                Changes10_6.assertEquals((int)12, (int)actualJdbcType);
                Changes10_6.assertEquals((int)expectedLength, (int)actualLength);
                break;
            }
            case 3: {
                RoutineAliasInfo rai = (RoutineAliasInfo)rs.getObject(1);
                TypeDescriptor td = rai.getReturnType();
                Changes10_6.assertEquals((int)12, (int)td.getJDBCTypeId());
                Changes10_6.assertEquals((int)correctLength, (int)td.getMaximumWidth());
            }
        }
        rs.close();
        s.close();
    }

    public void testSYSCS_INPLACE_COMPRESS_TABLE() throws Exception {
        Version firstVersionHavingPermissions;
        Version initialVersion = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        boolean beforePermissionsWereAdded = initialVersion.compareTo(firstVersionHavingPermissions = new Version(10, 2, 0, 0)) < 0;
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                if (beforePermissionsWereAdded) {
                    Changes10_6.assertStatementError(TABLE_DOES_NOT_EXIST, s, QUERY_4215);
                    break;
                }
                this.vetDERBY_4215(s);
                break;
            }
            case 3: {
                this.vetDERBY_4215(s);
            }
        }
        s.close();
    }

    private void vetDERBY_4215(Statement s) throws Exception {
        String expectedGrantor = "APP";
        ResultSet rs = s.executeQuery(QUERY_4215);
        Changes10_6.assertTrue((boolean)rs.next());
        String actualGrantor = rs.getString(1);
        Changes10_6.assertEquals((String)expectedGrantor, (String)actualGrantor);
        Changes10_6.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testUDTs() throws Exception {
        Statement s = this.createStatement();
        int phase = this.getPhase();
        switch (phase) {
            case 0: 
            case 2: {
                Changes10_6.assertStatementError(BAD_SYNTAX, s, CREATE_TYPE_DDL);
                Changes10_6.assertStatementError(BAD_SYNTAX, s, DROP_TYPE_DDL);
                break;
            }
            case 1: {
                Changes10_6.assertStatementError(UPGRADE_REQUIRED, s, CREATE_TYPE_DDL);
                Changes10_6.assertStatementError(UPGRADE_REQUIRED, s, DROP_TYPE_DDL);
                break;
            }
            case 3: {
                s.execute(CREATE_TYPE_DDL);
                s.execute(DROP_TYPE_DDL);
            }
        }
        s.close();
    }

    private Object getTypeDescriptor(Object routineAliasDescriptor) throws Exception {
        Method meth = routineAliasDescriptor.getClass().getMethod("getReturnType", null);
        return meth.invoke(routineAliasDescriptor, null);
    }

    private int getJDBCTypeId(Object typeDescriptor) throws Exception {
        Method meth = typeDescriptor.getClass().getMethod("getJDBCTypeId", null);
        return (Integer)meth.invoke(typeDescriptor, null);
    }

    private int getMaximumWidth(Object typeDescriptor) throws Exception {
        Method meth = typeDescriptor.getClass().getMethod("getMaximumWidth", null);
        return (Integer)meth.invoke(typeDescriptor, null);
    }

    public void testBuiltinAuthenticationHashNotChangedOnUpgrade() throws SQLException {
        Changes10_6.assertNull((Object)this.getDatabaseProperty(HASH_ALGORITHM_PROPERTY));
    }
}

