/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClientSideSystemPropertiesTest
extends BaseJDBCTestCase {
    public void testConnection() throws Exception {
        Connection connection = this.openDefaultConnection();
        connection.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        connection.rollback();
        connection.close();
    }

    public void testClientDataSourceConnection() throws Exception {
        Connection connection = JDBCDataSource.getDataSource().getConnection();
        connection.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        connection.rollback();
        connection.close();
    }

    public void testClientCPDataSourceConnection() throws Exception {
        PooledConnection pooledConnection = J2EEDataSource.getConnectionPoolDataSource().getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        connection.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        connection.rollback();
        connection.close();
        pooledConnection.close();
    }

    public void testClientXADataSourceConnection() throws Exception {
        XAConnection xAConnection = J2EEDataSource.getXADataSource().getXAConnection();
        Connection connection = xAConnection.getConnection();
        connection.setAutoCommit(false);
        this.checkTraceFileIsPresent();
        connection.close();
        xAConnection.close();
    }

    private void checkTraceFileIsPresent() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                int n;
                File file = new File(ClientSideSystemPropertiesTest.getSystemProperty("derby.client.traceDirectory"));
                File[] fileArray = file.listFiles();
                for (n = 0; n < fileArray.length; ++n) {
                    File file2 = fileArray[n];
                }
                Assert.assertTrue((n > 0 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    protected void setUp() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                File file = new File(ClientSideSystemPropertiesTest.getSystemProperty("derby.client.traceDirectory"));
                if (!file.exists()) {
                    Assert.assertTrue((file.mkdir() || file.mkdirs() ? 1 : 0) != 0);
                } else {
                    File[] fileArray = file.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file2 = fileArray[i];
                        Assert.assertTrue((boolean)file2.delete());
                    }
                }
                return null;
            }
        });
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        ClientSideSystemPropertiesTest.removeDirectory(ClientSideSystemPropertiesTest.getSystemProperty("derby.client.traceDirectory"));
    }

    public ClientSideSystemPropertiesTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.client.traceLevel", "64");
        properties.setProperty("derby.client.traceDirectory", "TraceDir");
        Test test = TestConfiguration.clientServerSuite(ClientSideSystemPropertiesTest.class);
        return new SystemPropertyTestSetup(test, properties);
    }
}

