/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XATestUtil;

public class XATransactionTest
extends BaseJDBCTestCase {
    public void testPendingLocalTranAndServerShutdown() throws Exception {
        if (XATransactionTest.usingEmbedded()) {
            return;
        }
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table tab(i int)");
        statement.executeUpdate("insert into tab values (1),(2),(3),(4)");
        connection.commit();
        connection.setAutoCommit(false);
        ResultSet resultSet = statement.executeQuery("select * from tab");
        resultSet.next();
        TestConfiguration.getCurrent().stopNetworkServer();
        TestConfiguration.getCurrent().startNetworkServer();
    }

    public void testGlobalXIDinTransactionTable() throws Exception {
        Statement statement = this.getConnection().createStatement();
        statement.execute("create table XATT2 (i int, text char(10))");
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Connection connection = xAConnection.getConnection();
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        for (int i = 0; i < 64; ++i) {
            byArray[i] = (byte)i;
            byArray2[i] = (byte)(64 - i);
        }
        Xid xid = XATestUtil.getXid(4660, byArray, byArray2);
        xAConnection = xADataSource.getXAConnection();
        xAResource = xAConnection.getXAResource();
        connection = xAConnection.getConnection();
        xAResource.start(xid, 0);
        statement = connection.createStatement();
        statement.execute("insert into XATT2 values (1234, 'Test_Entry')");
        statement.close();
        xAResource.end(xid, 0x4000000);
        ResultSet resultSet = null;
        statement = null;
        try {
            statement = this.getConnection().createStatement();
            String string = "select global_xid from syscs_diag.transaction_table where global_xid is not null";
            resultSet = statement.executeQuery(string);
            XATransactionTest.assertTrue((boolean)resultSet.next());
            Xid xid2 = XATransactionTest.parseXid(resultSet.getString(1));
            XATransactionTest.assertEquals((Object)xid, (Object)xid2);
            XATransactionTest.assertFalse((boolean)resultSet.next());
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                xAResource.rollback(xid);
                xAConnection.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        resultSet.close();
        statement.close();
        xAResource.rollback(xid);
        xAConnection.close();
    }

    public void testXATransactionTimeout() throws Exception {
        Object object;
        int n = 66;
        int n2 = 3;
        int n3 = (n + n2 - 1) / n2;
        Statement statement = this.getConnection().createStatement();
        statement.execute("create table XATT (i int, text char(10))");
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection[] xAConnectionArray = new XAConnection[n];
        XAResource xAResource = null;
        Connection connection = null;
        for (int i = 0; i < n; ++i) {
            xAConnectionArray[i] = xADataSource.getXAConnection();
            xAResource = xAConnectionArray[i].getXAResource();
            connection = xAConnectionArray[i].getConnection();
            object = XATransactionTest.createXid(123, i);
            xAResource.setTransactionTimeout(8);
            xAResource.start((Xid)object, 0);
            statement = connection.createStatement();
            statement.execute("insert into XATT values (" + i + ", 'Test_Entry')");
            if (i % n2 == 0) {
                statement.close();
                xAResource.end((Xid)object, 0x4000000);
                xAResource.prepare((Xid)object);
                xAResource.commit((Xid)object, false);
                continue;
            }
            if (i % 11 != 0) {
                block8: {
                    try {
                        xAResource.end((Xid)object, 0x20000000);
                        XATransactionTest.fail();
                    }
                    catch (XAException xAException) {
                        if (xAException.errorCode >= 100 && xAException.errorCode <= 107) break block8;
                        throw xAException;
                    }
                }
                statement.close();
                continue;
            }
            if (i % 2 != 0) continue;
            xAResource.end((Xid)object, 0x4000000);
            statement.close();
        }
        ResultSet resultSet = null;
        statement = this.getConnection().createStatement();
        resultSet = statement.executeQuery("select count(*) from XATT");
        resultSet.next();
        XATransactionTest.assertTrue((resultSet.getInt(1) == n3 ? 1 : 0) != 0);
        object = xADataSource.getXAConnection();
        xAResource = object.getXAResource();
        connection = object.getConnection();
        Xid xid = XATransactionTest.createXid(124, 100);
        xAResource.setTransactionTimeout(10);
        xAResource.start(xid, 0);
        statement = connection.createStatement();
        try {
            resultSet = statement.executeQuery("select count(*) from sys.syscolumns a, sys.syscolumns b, sys.syscolumns c, sys.syscolumns d, sys.syscolumns e group by a.referenceid, b.referenceid, c.referenceid, d.referenceid");
            XATransactionTest.fail((String)"An exception is expected here");
        }
        catch (SQLException sQLException) {
            XATransactionTest.assertSQLState("XCL52.S".substring(0, 5), sQLException);
        }
        statement = this.getConnection().createStatement();
        resultSet = statement.executeQuery("select count(*) from XATT");
        resultSet.next();
        for (int i = 0; i < n; ++i) {
            XATransactionTest.assertNotNull((Object)xAConnectionArray[i]);
            xAConnectionArray[i].close();
        }
        XATransactionTest.assertTrue((resultSet.getInt(1) == n3 ? 1 : 0) != 0);
    }

    public void testTransactionTimeoutAndSuspendResume() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATestUtil.getXid(1, 2, 3);
        xAResource.setTransactionTimeout(500);
        xAResource.start(xid, 0);
        xAResource.end(xid, 0x2000000);
        xAResource.start(xid, 0x8000000);
        xAResource.end(xid, 0x4000000);
        xAResource.rollback(xid);
        xAConnection.close();
    }

    public void testTransactionTimeoutAndJoin() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATestUtil.getXid(4, 5, 6);
        xAResource.setTransactionTimeout(500);
        xAResource.start(xid, 0);
        xAResource.end(xid, 0x4000000);
        XAConnection xAConnection2 = xADataSource.getXAConnection();
        XAResource xAResource2 = xAConnection2.getXAResource();
        xAResource2.setTransactionTimeout(500);
        Xid xid2 = XATestUtil.getXid(4, 5, 7);
        xAResource2.start(xid2, 0);
        xAResource2.end(xid2, 0x4000000);
        xAResource2.rollback(xid2);
        XATransactionTest.assertTrue((String)"Branches can only be joined if RM is same", (boolean)xAResource.isSameRM(xAResource2));
        xAResource2.start(xid, 0x200000);
        xAResource2.end(xid, 0x4000000);
        xAResource2.rollback(xid);
        xAConnection.close();
        xAConnection2.close();
    }

    public void testXAExceptionErrorCodeOnSQLExceptionDerby4141() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATransactionTest.createXid(123, 1);
        xAConnection.close();
        try {
            xAResource.start(xid, 0);
            XATransactionTest.fail((String)"Should have gotten an XAException. xaConn is closed.");
        }
        catch (XAException xAException) {
            XATransactionTest.assertEquals((int)-7, (int)xAException.errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForgetExceptionDerby1016PROTO() throws XAException, SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATransactionTest.createXid(93, 18);
        xAResource.start(xid, 0);
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE Derby1016 (I INT)");
        xAResource.end(xid, 0x4000000);
        xAResource.prepare(xid);
        try {
            xAResource.forget(xid);
            XATransactionTest.fail((String)"FAIL: prepared XA-Transaction forgotten");
        }
        catch (XAException xAException) {
            XATransactionTest.assertEquals((String)("FAIL: Got unexpected exception " + xAException.getMessage() + " errorCode: " + xAException.errorCode + "  calling forget on a prepared transaction"), (int)-6, (int)xAException.errorCode);
        }
        finally {
            statement.close();
            xAResource.rollback(xid);
            connection.close();
            xAConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForgetExceptionDerby1016NOTA() throws XAException, SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATransactionTest.createXid(93, 18);
        xAResource.start(xid, 0);
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE Derby1016 (I INT)");
        xAResource.end(xid, 0x4000000);
        xAResource.prepare(xid);
        xAResource.commit(xid, false);
        try {
            xAResource.forget(xid);
            XATransactionTest.fail((String)"FAIL: able to forget committed XA-Transaction");
        }
        catch (XAException xAException) {
            XATransactionTest.assertEquals((String)("FAIL: Got unexpected exception " + xAException.getMessage() + " errorCode: " + xAException.errorCode + "  calling forget on a committed transaction"), (int)-4, (int)xAException.errorCode);
        }
        finally {
            statement.executeUpdate("DROP TABLE Derby1016");
            connection.commit();
            statement.close();
            connection.close();
            xAConnection.close();
        }
    }

    public void testDerby5562ReadOnlyTimeout() throws InterruptedException, SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Xid xid = XATransactionTest.createXid(55, 62);
        XATransactionTest.assertTrue((boolean)xAResource.setTransactionTimeout(4));
        xAResource.start(xid, 0);
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from sysibm.sysdummy1"), "Y");
        statement.close();
        connection.close();
        xAResource.end(xid, 0x4000000);
        XATransactionTest.assertEquals((String)"XA_RDONLY", (int)3, (int)xAResource.prepare(xid));
        XATransactionTest.assertTrue((boolean)xAResource.setTransactionTimeout(0));
        xAResource.start(xid, 0);
        connection = xAConnection.getConnection();
        statement = connection.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from sysibm.sysdummy1"), "Y");
        statement.close();
        connection.close();
        Thread.sleep(5000L);
        xAResource.end(xid, 0x4000000);
        XATransactionTest.assertEquals((String)"XA_RDONLY", (int)3, (int)xAResource.prepare(xid));
        xAConnection.close();
    }

    static Xid createXid(int n, int n2) throws XAException {
        byte[] byArray = new byte[]{(byte)(n % 256), (byte)(n / 256)};
        byte[] byArray2 = new byte[]{(byte)(n2 % 256), (byte)(n2 / 256)};
        return XATestUtil.getXid(4660, byArray, byArray2);
    }

    private static Xid parseXid(String string) {
        int n;
        XATransactionTest.assertNotNull((Object)string);
        XATransactionTest.assertTrue((boolean)string.matches("\\(\\p{Digit}+,\\p{XDigit}+,\\p{XDigit}+\\)"));
        String string2 = string.substring(1, string.indexOf(44));
        String string3 = string.substring(string.indexOf(44) + 1, string.lastIndexOf(44));
        String string4 = string.substring(string.lastIndexOf(44) + 1, string.length() - 1);
        XATransactionTest.assertTrue((string3.length() % 2 == 0 ? 1 : 0) != 0);
        XATransactionTest.assertTrue((string4.length() % 2 == 0 ? 1 : 0) != 0);
        int n2 = Integer.parseInt(string2);
        byte[] byArray = new byte[string3.length() / 2];
        byte[] byArray2 = new byte[string4.length() / 2];
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = (byte)Integer.parseInt(string3.substring(2 * n, 2 * n + 2), 16);
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[n] = (byte)Integer.parseInt(string4.substring(2 * n, 2 * n + 2), 16);
        }
        return XATestUtil.getXid(n2, byArray, byArray2);
    }

    public XATransactionTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            Test test = TestConfiguration.defaultSuite(XATransactionTest.class);
            test = DatabasePropertyTestSetup.setLockTimeouts(test, 20, 60);
            return test;
        }
        return new BaseTestSuite("XATransactionTest cannot run without XA support");
    }
}

