/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.source.SourceElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourcePath {
    private static final String PATH_LEVEL_SEPARATOR = "/";
    private static final String THIS_TOKEN = ".";
    private static final String PARENT_TOKEN = "..";
    private static final String ANY_ELEMENT_TOKEN = "*";

    private SourcePath() {
    }

    public static boolean hasChild(SourceElement sourceElement, String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        for (SourceElement child : sourceElement.getChildren()) {
            if (!name.equals(child.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFollowing(SourceElement sourceElement) {
        return !SourcePath.getFollowing(sourceElement, null).isEmpty();
    }

    public static boolean hasPreceding(SourceElement sourceElement) {
        return !SourcePath.getPreceding(sourceElement, sourceElement.getName()).isEmpty();
    }

    public static boolean hasFollowingSibling(SourceElement sourceElement) {
        return !SourcePath.getFollowing(sourceElement, sourceElement.getName()).isEmpty();
    }

    public static boolean hasPrecedingSibling(SourceElement sourceElement) {
        return !SourcePath.getPreceding(sourceElement, sourceElement.getName()).isEmpty();
    }

    public static List<SourceElement> getPreceding(SourceElement sourceElement, String name) {
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        ArrayList<SourceElement> result = new ArrayList<SourceElement>();
        ListIterator<SourceElement> sameLevelIt = SourcePath.getSiblingIteratorPositionedOnSelf(sourceElement);
        if (sameLevelIt == null) {
            return result;
        }
        boolean first = true;
        while (sameLevelIt.hasPrevious()) {
            SourceElement sameLevelElement = sameLevelIt.previous();
            if (first) {
                first = false;
                continue;
            }
            if (name != null && !name.equals(sameLevelElement.getName())) continue;
            result.add(sameLevelElement);
        }
        return result;
    }

    public static List<SourceElement> getFollowing(SourceElement sourceElement, String name) {
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        ArrayList<SourceElement> result = new ArrayList<SourceElement>();
        ListIterator<SourceElement> sameLevelIt = SourcePath.getSiblingIteratorPositionedOnSelf(sourceElement);
        if (sameLevelIt == null) {
            return result;
        }
        while (sameLevelIt.hasNext()) {
            SourceElement sameLevelElement = sameLevelIt.next();
            if (name != null && !name.equals(sameLevelElement.getName())) continue;
            result.add(sameLevelElement);
        }
        return result;
    }

    private static ListIterator<SourceElement> getSiblingIteratorPositionedOnSelf(SourceElement sourceElement) {
        SourceElement parent = sourceElement.getParent();
        if (parent == null) {
            return null;
        }
        ListIterator<SourceElement> sameLevelIt = parent.getChildren().listIterator();
        boolean found = false;
        while (sameLevelIt.hasNext()) {
            SourceElement sameLevelElement = sameLevelIt.next();
            if (sameLevelElement != sourceElement) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Inconsistent source tree: Source element " + sourceElement.getName() + " not found in the list of the children of its parent");
        }
        return sameLevelIt;
    }

    public static List<SourceElement> getElements(SourceElement sourceElement, String path) {
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        if (path.equals(THIS_TOKEN)) {
            ArrayList<SourceElement> result = new ArrayList<SourceElement>(1);
            result.add(sourceElement);
            return result;
        }
        StringTokenizer selectionPathTokenizer = new StringTokenizer(path, PATH_LEVEL_SEPARATOR);
        ArrayList<SourceElement> currentSelection = new ArrayList<SourceElement>();
        currentSelection.add(sourceElement);
        while (selectionPathTokenizer.hasMoreTokens()) {
            String childName = selectionPathTokenizer.nextToken();
            ArrayList<SourceElement> nextSelection = new ArrayList<SourceElement>();
            for (SourceElement currentElement : currentSelection) {
                if (childName.equals(PARENT_TOKEN)) {
                    SourceElement parent = currentElement.getParent();
                    if (parent != null && !nextSelection.contains(parent)) {
                        nextSelection.add(parent);
                    }
                } else if (ANY_ELEMENT_TOKEN.equals(childName)) {
                    for (SourceElement child : currentElement.getChildren()) {
                        nextSelection.add(child);
                    }
                }
                for (SourceElement child : currentElement.getChildren(childName)) {
                    nextSelection.add(child);
                }
            }
            currentSelection = nextSelection;
        }
        return currentSelection;
    }

    public static List<SourceElement> getElementsFromRoot(SourceElement rootElement, String path) {
        String firstElementName;
        int firstSeparatorPos;
        if (rootElement == null) {
            throw new NullPointerException("rootElement must not be null");
        }
        if (path == null || "".equals(path.trim()) || PATH_LEVEL_SEPARATOR.equals(path.trim())) {
            ArrayList<SourceElement> result = new ArrayList<SourceElement>(1);
            result.add(rootElement);
            return result;
        }
        if ((path = path.trim()).startsWith(PATH_LEVEL_SEPARATOR)) {
            path = path.substring(1);
        }
        if ((firstSeparatorPos = path.indexOf(PATH_LEVEL_SEPARATOR)) == -1) {
            firstElementName = path;
            path = THIS_TOKEN;
        } else {
            firstElementName = path.substring(0, firstSeparatorPos);
            path = path.substring(firstSeparatorPos + 1);
        }
        if (!ANY_ELEMENT_TOKEN.equals(firstElementName) && !rootElement.getName().equals(firstElementName)) {
            return new ArrayList<SourceElement>();
        }
        return SourcePath.getElements(rootElement, path);
    }

    public static SourceElement getElement(SourceElement sourceElement, String path, boolean acceptEmpty) throws GeneratorException {
        List<SourceElement> sourceElements = SourcePath.getElements(sourceElement, path);
        if (sourceElements.isEmpty()) {
            if (acceptEmpty) {
                return null;
            }
            throw new GeneratorException("Source element path " + path + " selects no element on source element " + sourceElement.getName());
        }
        if (sourceElements.size() > 1) {
            throw new GeneratorException("Source element path " + path + " selects more than a single element on source element " + sourceElement.getName());
        }
        return sourceElements.get(0);
    }

    public static String getPathAsString(SourceElement sourceElement) throws GeneratorException {
        StringBuilder result = new StringBuilder();
        SourcePath.getParentPath(sourceElement, new HashSet<SourceElement>(), result);
        result.append(sourceElement.getName());
        return result.toString();
    }

    private static void getParentPath(SourceElement toProcess, Set<SourceElement> alreadyProcessed, StringBuilder result) throws GeneratorException {
        SourceElement parent = toProcess.getParent();
        if (alreadyProcessed.contains(parent)) {
            throw new GeneratorException("getParentPath(): invoked on a closed loop");
        }
        if (parent == null) {
            return;
        }
        result.insert(0, parent.getName() + PATH_LEVEL_SEPARATOR);
        alreadyProcessed.add(parent);
        SourcePath.getParentPath(parent, alreadyProcessed, result);
    }
}

