package org.apache.torque.generator.configuration.mergepoint;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * The element and attribute names for mergepoint configuration.
 */
public final class MergepointConfigurationTags
{
    /**
     * private constructor for utility class.
     */
    private MergepointConfigurationTags()
    {
    }

    /** Tag name for the "mergepoint" tag. */
    public static final String MERGEPOINT_TAG = "mergepoint";

    /** Attribute name for the "name" attribute of the "mergepoint" tag. */
    public static final String MERGEPOINT_NAME_ATTRIBUTE = "name";

    /** Tag name for the "action" tag. */
    public static final String ACTION_TAG = "action";

    /** Attribute name for the "type" attribute of the "action" tag. */
    public static final String ACTION_TYPE_ATTRIBUTE = "type";

    /** Attribute name for the "outlet" attribute of the "action" tag. */
    public static final String ACTION_OUTLET_ATTRIBUTE = "outlet";

    /** Attribute name for the "attribute" attribute of the "action" tag. */
    public static final String ACTION_ATTRIBUTE_ATTRIBUTE = "attribute";

    /** Attribute name for the "element" attribute of the "action" tag. */
    public static final String ACTION_ELEMENT_ATTRIBUTE = "element";

    /** Attribute name for the "acceptEmpty" attribute of the "action" tag. */
    public static final String ACTION_ACCEPT_EMPTY_ATTRIBUTE = "acceptEmpty";

    /** Attribute name for the "acceptNotSet" attribute of the "action" tag. */
    public static final String ACTION_ACCEPT_NOT_SET_ATTRIBUTE = "acceptNotSet";

    /** Attribute name for the "option" attribute of the "action" tag. */
    public static final String ACTION_OPTION_ATTRIBUTE = "option";

    /** Attribute name for the "value" attribute of the "action" tag. */
    public static final String ACTION_VALUE_ATTRIBUTE = "value";
}


