/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.paths;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.torque.generator.configuration.paths.ProjectPaths;

public class CustomProjectPaths
implements ProjectPaths {
    private File configurationDir;
    private String configurationPackage;
    private File sourceDir;
    private Map<String, File> outputDirectoryMap = new HashMap<String, File>();
    private File workDir;
    private File cacheDir;

    public CustomProjectPaths(ProjectPaths toCopy) {
        this.configurationDir = toCopy.getConfigurationPath();
        this.configurationPackage = toCopy.getConfigurationPackage();
        this.sourceDir = toCopy.getDefaultSourcePath();
        this.outputDirectoryMap = new HashMap<String, File>(toCopy.getOutputDirectoryMap());
        this.workDir = toCopy.getWorkDirectory();
        this.cacheDir = toCopy.getCacheDirectory();
    }

    public CustomProjectPaths(File configurationDir, String configurationPackage, File sourceDir, Map<String, File> outputDirectoryMap, File workDir, File cacheDir) {
        this.configurationDir = configurationDir;
        this.configurationPackage = configurationPackage;
        this.sourceDir = sourceDir;
        this.outputDirectoryMap = new HashMap<String, File>(outputDirectoryMap);
        this.workDir = workDir;
        this.cacheDir = cacheDir;
    }

    public void setConfigurationDir(File configurationDir) {
        this.configurationDir = configurationDir;
    }

    public void setConfigurationPackage(String configurationPackage) {
        this.configurationPackage = configurationPackage;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setOutputDirectory(String outputDirKey, File outputDir) {
        this.outputDirectoryMap.put(outputDirKey, outputDir);
    }

    public void setOutputDirectoryMap(Map<String, File> outputDirectoryMap) {
        this.outputDirectoryMap.clear();
        this.outputDirectoryMap.putAll(outputDirectoryMap);
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public File getConfigurationPath() {
        this.checkInit();
        return this.configurationDir;
    }

    @Override
    public String getConfigurationPackage() {
        this.checkInit();
        return this.configurationPackage;
    }

    @Override
    public File getDefaultSourcePath() {
        this.checkInit();
        return this.sourceDir;
    }

    @Override
    public File getOutputDirectory(String outputDirKey) {
        this.checkInit();
        File result = this.outputDirectoryMap.get(outputDirKey);
        if (result == null) {
            throw new IllegalArgumentException("unknown outputDirKey " + outputDirKey);
        }
        return result;
    }

    @Override
    public Map<String, File> getOutputDirectoryMap() {
        this.checkInit();
        return this.outputDirectoryMap;
    }

    @Override
    public File getWorkDirectory() {
        this.checkInit();
        return this.workDir;
    }

    @Override
    public File getCacheDirectory() {
        this.checkInit();
        return this.cacheDir;
    }

    public void checkInit() {
        if (this.configurationDir == null && this.configurationPackage == null) {
            throw new IllegalStateException("configurationDir or configurationPackage must not be null.");
        }
        if (this.sourceDir == null) {
            throw new IllegalStateException("sourceDir must not be null.");
        }
        if (this.outputDirectoryMap.get(null) == null) {
            throw new IllegalStateException("default output directory must not be null.");
        }
        if (this.workDir == null) {
            throw new IllegalStateException("workDir must not be null.");
        }
        if (this.cacheDir == null) {
            throw new IllegalStateException("cacheDir must not be null.");
        }
    }

    public String toString() {
        return "(CustomProjectPaths: configurationDir=" + this.configurationDir + ", configurationPackage=" + this.configurationPackage + ", sourceDir=" + this.sourceDir + ", outputDirectoryMap=" + this.outputDirectoryMap + ", workDir=" + this.workDir + ", cacheDir=" + this.cacheDir + ")";
    }
}

