/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.util.Objects;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.generator.source.SourceElement;

public class SourceElementAttributePointer
extends NodePointer {
    private static final long serialVersionUID = 1115085175427555951L;
    private final SourceElement sourceElement;
    private final String name;

    public SourceElementAttributePointer(NodePointer parent, SourceElement sourceElement, String name) {
        super(parent);
        this.sourceElement = sourceElement;
        this.name = name;
    }

    public QName getName() {
        return new QName(null, this.name);
    }

    public String getNamespaceURI() {
        return null;
    }

    public Object getValue() {
        return this.sourceElement.getAttribute(this.name);
    }

    public Object getBaseValue() {
        return this.sourceElement.getAttribute(this.name);
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public Object getImmediateNode() {
        return this.sourceElement.getAttribute(this.name);
    }

    public boolean isActual() {
        return true;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean testNode(NodeTest nodeTest) {
        return nodeTest == null || nodeTest instanceof NodeTypeTest && ((NodeTypeTest)nodeTest).getNodeType() == 1;
    }

    public void setValue(Object value) {
        this.sourceElement.setAttribute(this.name, value);
    }

    public void remove() {
        this.sourceElement.setAttribute(this.name, null);
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append('@');
        buffer.append(this.getName());
        return buffer.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.sourceElement).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SourceElementAttributePointer)) {
            return false;
        }
        SourceElementAttributePointer other = (SourceElementAttributePointer)((Object)object);
        if (this.sourceElement != other.sourceElement) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }
}

