/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jcs.access.AbstractCacheAccess;
import org.apache.commons.jcs.access.behavior.IGroupCacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.InvalidArgumentException;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.control.group.GroupId;

public class GroupCacheAccess<K, V>
extends AbstractCacheAccess<GroupAttrName<K>, V>
implements IGroupCacheAccess<K, V> {
    public GroupCacheAccess(CompositeCache<GroupAttrName<K>, V> cacheControl) {
        super(cacheControl);
    }

    @Override
    public V getFromGroup(K name, String group) {
        ICacheElement element = this.getCacheControl().get(this.getGroupAttrName(group, name));
        return element != null ? (V)element.getVal() : null;
    }

    private GroupAttrName<K> getGroupAttrName(String group, K name) {
        GroupId gid = new GroupId(this.getCacheControl().getCacheName(), group);
        return new GroupAttrName<K>(gid, name);
    }

    @Override
    public void putInGroup(K name, String groupName, V value) throws CacheException {
        this.putInGroup(name, groupName, value, null);
    }

    @Override
    public void putInGroup(K name, String groupName, V value, IElementAttributes attr) throws CacheException {
        if (name == null) {
            throw new InvalidArgumentException("Key must not be null");
        }
        if (value == null) {
            throw new InvalidArgumentException("Value must not be null");
        }
        try {
            GroupAttrName<K> key = this.getGroupAttrName(groupName, name);
            CacheElement<GroupAttrName<K>, V> ce = new CacheElement<GroupAttrName<K>, V>(this.getCacheControl().getCacheName(), key, value);
            IElementAttributes attributes = attr == null ? this.getCacheControl().getElementAttributes() : attr;
            ce.setElementAttributes(attributes);
            this.getCacheControl().update(ce);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void removeFromGroup(K name, String group) {
        GroupAttrName<K> key = this.getGroupAttrName(group, name);
        this.getCacheControl().remove(key);
    }

    @Override
    public Set<K> getGroupKeys(String group) {
        HashSet groupKeys = new HashSet();
        GroupId groupId = new GroupId(this.getCacheControl().getCacheName(), group);
        for (GroupAttrName gan : this.getCacheControl().getKeySet()) {
            if (!gan.groupId.equals(groupId)) continue;
            groupKeys.add(gan.attrName);
        }
        return groupKeys;
    }

    public Set<String> getGroupNames() {
        HashSet<String> names = new HashSet<String>();
        for (GroupAttrName gan : this.getCacheControl().getKeySet()) {
            names.add(gan.groupId.groupName);
        }
        return names;
    }

    @Override
    public void invalidateGroup(String group) {
        this.getCacheControl().remove(this.getGroupAttrName(group, null));
    }
}

