/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(CacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.SINGLE;
    private Thread processorThread;
    private LinkedBlockingQueue<AbstractCacheEventQueue.AbstractCacheEvent> queue = new LinkedBlockingQueue();

    public CacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName) {
        this(listener, listenerId, cacheName, 10, 500);
    }

    public CacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry) {
        this.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry);
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    protected void stopProcessing() {
        this.setAlive(false);
        this.processorThread = null;
    }

    @Override
    public void destroy() {
        if (this.isAlive()) {
            this.setAlive(false);
            if (log.isInfoEnabled()) {
                log.info((Object)("Destroying queue, stats =  " + this.getStatistics()));
            }
            if (this.processorThread != null) {
                this.processorThread.interrupt();
                this.processorThread = null;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Cache event queue destroyed: " + this));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Destroy was called after queue was destroyed. Doing nothing. Stats =  " + this.getStatistics()));
        }
    }

    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event entering Queue for " + this.getCacheName() + ": " + event));
        }
        this.queue.offer(event);
        if (this.isWorking() && !this.isAlive()) {
            this.setAlive(true);
            this.processorThread = new QProcessor();
            this.processorThread.start();
            if (log.isInfoEnabled()) {
                log.info((Object)("Cache event queue created: " + this));
            }
        }
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Cache Event Queue");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Working", this.isWorking()));
        elems.add(new StatElement<Boolean>("Alive", this.isAlive()));
        elems.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        elems.add(new StatElement<Integer>("Size", this.size()));
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    protected class QProcessor
    extends Thread {
        QProcessor() {
            super("CacheEventQueue.QProcessor-" + CacheEventQueue.this.getCacheName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (CacheEventQueue.this.isAlive()) {
                AbstractCacheEventQueue.AbstractCacheEvent event = null;
                try {
                    event = (AbstractCacheEventQueue.AbstractCacheEvent)CacheEventQueue.this.queue.poll(CacheEventQueue.this.getWaitToDieMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event from queue = " + event));
                }
                if (event == null) {
                    CacheEventQueue.this.stopProcessing();
                }
                if (event == null || !CacheEventQueue.this.isWorking() || !CacheEventQueue.this.isAlive()) continue;
                event.run();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("QProcessor exiting for " + CacheEventQueue.this.getCacheName()));
            }
        }
    }
}

