/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.template.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.template.groovy.GroovyOutlet;

public class GroovyScriptOutlet
extends GroovyOutlet {
    private static volatile GroovyShell groovyShell = null;
    private static Map<String, Script> cachedScripts = new HashMap<String, Script>();

    GroovyShell getInstance(ClassLoader cl) {
        if (groovyShell == null) {
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            groovyShell = new GroovyShell(cl);
        }
        return groovyShell;
    }

    public GroovyScriptOutlet(QualifiedName name, ConfigurationProvider configurationProvider, String path, String encoding) throws ConfigurationException {
        super(name, configurationProvider, path, encoding);
    }

    @Override
    protected String executeGroovy(Map<String, Object> binding, ControllerState controllerState) throws GeneratorException {
        try {
            String detokenizedPath = this.getDetokenizedPath(controllerState);
            Script script = cachedScripts.get(detokenizedPath);
            if (script == null) {
                GroovyShell gs = this.getInstance(controllerState.getUnitConfiguration().getClassLoader());
                script = gs.parse(this.getContent(controllerState));
                cachedScripts.put(detokenizedPath, script);
            }
            Binding scriptBinding = new Binding(binding);
            script.setBinding(scriptBinding);
            Object result = script.run();
            if (result == null) {
                return "";
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new GeneratorException("Error executing groovy script " + String.valueOf(this.getName()), e);
        }
    }
}

