/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om.mapper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.torque.TorqueException;

public class MappingStrategy<T> {
    private final List<Pair<Integer, FailableBiConsumer<ResultSet, T, TorqueException>>> tasks = new ArrayList<Pair<Integer, FailableBiConsumer<ResultSet, T, TorqueException>>>();
    private boolean allSet = false;

    public void addColumn(int offset, FailableBiConsumer<ResultSet, T, TorqueException> setter) {
        this.tasks.add(Pair.of((Object)offset, setter));
    }

    public void finish(int num_fields, boolean sort) {
        if (sort) {
            this.tasks.sort(Comparator.comparing(Pair::getLeft));
        }
        this.allSet = this.tasks.size() == num_fields;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public boolean isAllSet() {
        return this.allSet;
    }

    public void reset() {
        this.tasks.clear();
    }

    public void execute(ResultSet result, T instance) {
        this.tasks.stream().forEach(strategy -> {
            try {
                ((FailableBiConsumer)strategy.getRight()).accept((Object)result, instance);
            }
            catch (TorqueException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

