/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.ReviewMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReviewMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)ReviewMgrImpl.class.getName());

    ReviewMgrImpl() {
    }

    FortResponse readPermission(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            Permission inPerm = (Permission)request.getEntity();
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Permission retPerm = reviewMgr.readPermission(inPerm);
            response.setEntity((FortEntity)retPerm);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readPermObj(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PermObj inObj = (PermObj)request.getEntity();
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            PermObj retObj = reviewMgr.readPermObj(inObj);
            response.setEntity((FortEntity)retObj);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findPermissions(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Permission inPerm = (Permission)request.getEntity();
            List perms = reviewMgr.findPermissions(inPerm);
            response.setEntities(perms);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findObjPermissions(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            PermObj inObj = (PermObj)request.getEntity();
            List perms = reviewMgr.findPermsByObj(inObj);
            response.setEntities(perms);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findAnyPermissions(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Permission inPerm = (Permission)request.getEntity();
            List perms = reviewMgr.findAnyPermissions(inPerm);
            response.setEntities(perms);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findPermObjs(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            PermObj inObj = (PermObj)request.getEntity();
            List objs = null;
            objs = StringUtils.isNotEmpty((String)inObj.getOu()) ? reviewMgr.findPermObjs(new OrgUnit(inObj.getOu(), OrgUnit.Type.PERM)) : reviewMgr.findPermObjs(inObj);
            response.setEntities(objs);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            Role outRole = reviewMgr.readRole(inRole);
            response.setEntity((FortEntity)outRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            String searchValue = request.getValue();
            if (request.getLimit() != null) {
                List retRoles = reviewMgr.findRoles(searchValue, request.getLimit().intValue());
                response.setValues(retRoles);
            } else {
                List roles = reviewMgr.findRoles(searchValue);
                response.setEntities(roles);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readUserM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            User outUser = reviewMgr.readUser(inUser);
            response.setEntity((FortEntity)outUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findUsersM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            if (request.getLimit() != null) {
                List retUsers = reviewMgr.findUsers(inUser, request.getLimit().intValue());
                response.setValues(retUsers);
            } else {
                List retUsers = StringUtils.isNotEmpty((String)inUser.getOu()) ? reviewMgr.findUsers(new OrgUnit(inUser.getOu(), OrgUnit.Type.USER)) : reviewMgr.findUsers(inUser);
                response.setEntities(retUsers);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedUsersM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            if (request.getLimit() != null) {
                List retUsers = reviewMgr.assignedUsers(inRole, request.getLimit().intValue());
                response.setValues(retUsers);
            } else {
                List users = reviewMgr.assignedUsers(inRole);
                response.setEntities(users);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedUsersConstraints(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            RoleConstraint inConstraint = (RoleConstraint)request.getEntity2();
            List users = reviewMgr.assignedUsers(inRole, inConstraint);
            response.setEntities(users);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedUsersConstraintsKey(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            RoleConstraint inConstraint = (RoleConstraint)request.getEntity2();
            List uRoles = reviewMgr.assignedUsers(inRole, inConstraint.getType(), inConstraint.getKey());
            response.setEntities(uRoles);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedRolesM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            if (StringUtils.isNotEmpty((String)request.getValue())) {
                String userId = request.getValue();
                List retRoles = reviewMgr.assignedRoles(userId);
                response.setValues(retRoles);
            } else {
                User inUser = (User)request.getEntity();
                List uRoles = reviewMgr.assignedRoles(inUser);
                response.setEntities(uRoles);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse authorizedUsersM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            List users = reviewMgr.authorizedUsers(inRole);
            response.setEntities(users);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse authorizedRoleM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            Set outSet = reviewMgr.authorizedRoles(inUser);
            response.setValueSet(outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse permissionRolesM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Permission inPerm = (Permission)request.getEntity();
            List outList = reviewMgr.permissionRoles(inPerm);
            response.setValues(outList);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse authorizedPermissionRolesM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Permission inPerm = (Permission)request.getEntity();
            Set outSet = reviewMgr.authorizedPermissionRoles(inPerm);
            response.setValueSet(outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse permissionUsersM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            Permission inPerm = (Permission)request.getEntity();
            List outList = reviewMgr.permissionUsers(inPerm);
            response.setValues(outList);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse authorizedPermissionUsersM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            Permission inPerm = (Permission)request.getEntity();
            Set outSet = reviewMgr.authorizedPermissionUsers(inPerm);
            response.setValueSet(outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse userPermissionsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            List perms = reviewMgr.userPermissions(inUser);
            response.setEntities(perms);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse rolePermissionsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            boolean noInheritance = request.getIsFlag();
            List perms = reviewMgr.rolePermissions(inRole, noInheritance);
            response.setEntities(perms);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse ssdRoleSetsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            List outSets = reviewMgr.ssdRoleSets(inRole);
            response.setEntities(outSets);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse ssdRoleSetM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = reviewMgr.ssdRoleSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse ssdRoleSetRolesM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            SDSet inSet = (SDSet)request.getEntity();
            Set outSet = reviewMgr.ssdRoleSetRoles(inSet);
            response.setValueSet(outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse ssdRoleSetCardinalityM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            SDSet inSet = (SDSet)request.getEntity();
            int cardinality = reviewMgr.ssdRoleSetCardinality(inSet);
            inSet.setCardinality(Integer.valueOf(cardinality));
            response.setEntity((FortEntity)inSet);
        }
        catch (SecurityException se) {
            LOG.info("Caught " + se);
        }
        return response;
    }

    FortResponse ssdSetsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            SDSet inSdSet = (SDSet)request.getEntity();
            List outSets = reviewMgr.ssdSets(inSdSet);
            response.setEntities(outSets);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse dsdRoleSetsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            List outSets = reviewMgr.dsdRoleSets(inRole);
            response.setEntities(outSets);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse dsdRoleSetM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = reviewMgr.dsdRoleSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse dsdRoleSetRolesM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            SDSet inSet = (SDSet)request.getEntity();
            Set outSet = reviewMgr.dsdRoleSetRoles(inSet);
            response.setValueSet(outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse dsdRoleSetCardinalityM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            SDSet inSet = (SDSet)request.getEntity();
            int cardinality = reviewMgr.dsdRoleSetCardinality(inSet);
            inSet.setCardinality(Integer.valueOf(cardinality));
            response.setEntity((FortEntity)inSet);
        }
        catch (SecurityException se) {
            LOG.info("Caught " + se);
        }
        return response;
    }

    FortResponse dsdSetsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            SDSet inSdSet = (SDSet)request.getEntity();
            List outSets = reviewMgr.dsdSets(inSdSet);
            response.setEntities(outSets);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findRoleConstraintsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            Permission inPerm = (Permission)request.getEntity2();
            RoleConstraint.RCType inType = RoleConstraint.RCType.valueOf((String)request.getValue());
            List outConstraints = reviewMgr.findRoleConstraints(inUser, inPerm, inType);
            response.setEntities(outConstraints);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse rolePermissionAttributeSetsM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            boolean isReplace = request.getIsFlag();
            List retAttrSets = reviewMgr.rolePermissionAttributeSets(inRole, isReplace);
            response.setEntities(retAttrSets);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readPermAttributeSetM(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance((String)request.getContextId());
            reviewMgr.setAdmin(request.getSession());
            PermissionAttributeSet inSet = (PermissionAttributeSet)request.getEntity();
            PermissionAttributeSet outSet = reviewMgr.readPermAttributeSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

