/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalBlTrAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalBlTrWidthsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalTlBrAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalTlBrWidthsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRunThroughAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.BorderPropertiesImpl;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class GraphicProperties {
    private StyleGraphicPropertiesElement mElement;
    BorderPropertiesImpl mBorderPropertiesHandler;

    protected GraphicProperties(StyleGraphicPropertiesElement properties) {
        this.mElement = properties;
        this.mBorderPropertiesHandler = new BorderPropertiesImpl((OdfStylePropertiesBase)this.mElement);
    }

    public static GraphicProperties getOrCreateGraphicProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.GraphicProperties);
        return new GraphicProperties((StyleGraphicPropertiesElement)properties);
    }

    public static GraphicProperties getGraphicProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getPropertiesElement(OdfStylePropertiesSet.GraphicProperties);
        if (properties != null) {
            return new GraphicProperties((StyleGraphicPropertiesElement)properties);
        }
        return null;
    }

    public void setBorders(StyleTypeDefinitions.CellBordersType bordersType, Border border) {
        switch (bordersType) {
            case BOTTOM: {
                this.setBottomBorder(border);
                break;
            }
            case LEFT: {
                this.setLeftBorder(border);
                break;
            }
            case RIGHT: {
                this.setRightBorder(border);
                break;
            }
            case TOP: {
                this.setTopBorder(border);
                break;
            }
            case DIAGONALBLTR: {
                throw new RuntimeException("DIAGONALBL is not supported");
            }
            case DIAGONALTLBR: {
                throw new RuntimeException("DIAGONALTLBR is not supported");
            }
            case ALL_FOUR: {
                this.setBorder(border);
                break;
            }
            case LEFT_RIGHT: {
                this.setLeftBorder(border);
                this.setRightBorder(border);
                break;
            }
            case TOP_BOTTOM: {
                this.setTopBorder(border);
                this.setBottomBorder(border);
                break;
            }
            case DIAGONAL_LINES: {
                throw new RuntimeException("DIAGONAL_LINES is not supported");
            }
            case NONE: {
                this.mElement.removeAttribute(StyleBorderLineWidthAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthBottomAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderBottomAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthTopAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderTopAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthLeftAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderLeftAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthRightAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderRightAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalBlTrWidthsAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalBlTrAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalTlBrWidthsAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalTlBrAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public Border getBorder() {
        return this.mBorderPropertiesHandler.getBorder();
    }

    public Border getTopBorder() {
        return this.mBorderPropertiesHandler.getTopBorder();
    }

    public Border getLeftBorder() {
        return this.mBorderPropertiesHandler.getLeftBorder();
    }

    public Border getRightBorder() {
        return this.mBorderPropertiesHandler.getRightBorder();
    }

    public Border getBottomBorder() {
        return this.mBorderPropertiesHandler.getBottomBorder();
    }

    public void setBottomBorder(Border border) {
        this.mBorderPropertiesHandler.setBottomBorder(border);
    }

    public void setTopBorder(Border border) {
        this.mBorderPropertiesHandler.setTopBorder(border);
    }

    public void setLeftBorder(Border border) {
        this.mBorderPropertiesHandler.setLeftBorder(border);
    }

    public void setRightBorder(Border border) {
        this.mBorderPropertiesHandler.setRightBorder(border);
    }

    public void setBorder(Border border) {
        this.mBorderPropertiesHandler.setBorder(border);
    }

    public void setStroke(StyleTypeDefinitions.OdfDrawStroke stroke, Color color, String widthDesc, String dashStyleName) {
        switch (stroke) {
            case NONE: {
                this.mElement.setDrawStrokeAttribute("none");
                break;
            }
            case SOLID: {
                this.mElement.setDrawStrokeAttribute("solid");
                if (color != null) {
                    this.mElement.setSvgStrokeColorAttribute(color.toString());
                }
                if (widthDesc == null || widthDesc.length() <= 2 || !this.verifyWidthDesc(widthDesc)) break;
                this.mElement.setSvgStrokeWidthAttribute(widthDesc);
                break;
            }
            case DASH: {
                this.mElement.setDrawStrokeAttribute("dash");
                if (color != null) {
                    this.mElement.setSvgStrokeColorAttribute(color.toString());
                }
                if (widthDesc != null && widthDesc.length() > 2 && this.verifyWidthDesc(widthDesc)) {
                    this.mElement.setSvgStrokeWidthAttribute(widthDesc);
                }
                this.mElement.setDrawStrokeDashNamesAttribute(dashStyleName);
            }
        }
    }

    public void setFill(StyleTypeDefinitions.OdfDrawFill fillType, Color color) {
        switch (fillType) {
            case NONE: {
                this.mElement.setDrawFillAttribute("none");
                break;
            }
            case SOLID: {
                this.mElement.setDrawFillAttribute("solid");
                this.mElement.setDrawFillColorAttribute(color.toString());
                break;
            }
            case BITMAP: 
            case GRADIENT: 
            case HATCH: {
                throw new RuntimeException(fillType.toString() + " not supported!");
            }
        }
    }

    public void setStyleRunThrough(boolean isBackgroundObject) {
        if (isBackgroundObject) {
            this.mElement.setStyleRunThroughAttribute(StyleRunThroughAttribute.Value.BACKGROUND.toString());
        } else {
            this.mElement.setStyleRunThroughAttribute(StyleRunThroughAttribute.Value.FOREGROUND.toString());
        }
    }

    public void setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition horizontalPos) {
        this.mElement.setStyleHorizontalPosAttribute(horizontalPos.toString());
    }

    public void setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative relative) {
        this.mElement.setStyleHorizontalRelAttribute(relative.toString());
    }

    public void setVerticalRelative(StyleTypeDefinitions.VerticalRelative relative) {
        this.mElement.setStyleVerticalRelAttribute(relative.toString());
    }

    public void setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition verticalPos) {
        this.mElement.setStyleVerticalPosAttribute(verticalPos.toString());
    }

    public StyleTypeDefinitions.FrameHorizontalPosition getHorizontalPosition() {
        return StyleTypeDefinitions.FrameHorizontalPosition.enumValueOf(this.mElement.getStyleHorizontalPosAttribute());
    }

    public StyleTypeDefinitions.FrameVerticalPosition getVerticalPosition() {
        return StyleTypeDefinitions.FrameVerticalPosition.enumValueOf(this.mElement.getStyleVerticalPosAttribute());
    }

    public StyleTypeDefinitions.VerticalRelative getVerticalRelative() {
        return StyleTypeDefinitions.VerticalRelative.enumValueOf(this.mElement.getStyleVerticalRelAttribute());
    }

    public StyleTypeDefinitions.HorizontalRelative getHorizontalRelative() {
        return StyleTypeDefinitions.HorizontalRelative.enumValueOf(this.mElement.getStyleHorizontalRelAttribute());
    }

    private boolean verifyWidthDesc(String widthDesc) {
        char char1 = widthDesc.charAt(widthDesc.length() - 1);
        char char2 = widthDesc.charAt(widthDesc.length() - 2);
        if (!(char1 >= 'a' && char1 <= 'z' || char1 >= 'A' && char1 <= 'Z')) {
            return false;
        }
        if (!(char2 >= 'a' && char2 <= 'z' || char2 >= 'A' && char2 <= 'Z')) {
            return false;
        }
        String floatValue = widthDesc.substring(0, widthDesc.length() - 2).trim();
        try {
            Double.parseDouble(floatValue);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

