/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.reconciler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifCommentContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifNonEmptyLineBase;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class LdifFoldingRegionUpdater
implements IPropertyChangeListener {
    private ILdifEditor editor;

    public LdifFoldingRegionUpdater(ILdifEditor editor) {
        this.editor = editor;
        LdifEditorActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        LdifEditorActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("ldifEditorFoldingEnable".equals(event.getProperty()) || "ldifEditorFoldingInitiallyFoldComments".equals(event.getProperty()) || "ldifEditoroldingInitiallyFoldRecords".equals(event.getProperty()) || "ldifEditorFoldingInitiallyFoldWrappedLines".equals(event.getProperty())) {
            this.updateFoldingRegions();
        }
    }

    public void updateFoldingRegions() {
        ISourceViewer viewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class);
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        try {
            ProjectionAnnotationModel projectionAnnotationModel = (ProjectionAnnotationModel)this.editor.getAdapter(ProjectionAnnotationModel.class);
            if (projectionAnnotationModel == null) {
                return;
            }
            Map<Position, ProjectionAnnotation> positionToAnnotationMap = this.createFoldingRegions(this.editor.getLdifModel(), document);
            ArrayList<Annotation> annotationsToDeleteList = new ArrayList<Annotation>();
            HashMap<ProjectionAnnotation, Position> annotationsToAddMap = new HashMap<ProjectionAnnotation, Position>();
            this.computeDifferences(projectionAnnotationModel, positionToAnnotationMap, annotationsToDeleteList, annotationsToAddMap);
            Annotation[] annotationsToDelete = annotationsToDeleteList.toArray(new Annotation[annotationsToDeleteList.size()]);
            if (!annotationsToDeleteList.isEmpty() || !annotationsToAddMap.isEmpty()) {
                projectionAnnotationModel.modifyAnnotations(annotationsToDelete, annotationsToAddMap, new Annotation[0]);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void computeDifferences(ProjectionAnnotationModel model, Map<Position, ProjectionAnnotation> positionToAnnotationMap, List<Annotation> annotationsToDeleteList, Map<ProjectionAnnotation, Position> annotationsToAddMap) {
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = model.getPosition(annotation);
            if (positionToAnnotationMap.containsKey(position)) {
                positionToAnnotationMap.remove(position);
                continue;
            }
            annotationsToDeleteList.add(annotation);
        }
        for (Map.Entry<Position, ProjectionAnnotation> entry : positionToAnnotationMap.entrySet()) {
            annotationsToAddMap.put(entry.getValue(), entry.getKey());
        }
    }

    private Map<Position, ProjectionAnnotation> createFoldingRegions(LdifFile model, IDocument document) throws BadLocationException {
        HashMap<Position, ProjectionAnnotation> positionToAnnotationMap = new HashMap<Position, ProjectionAnnotation>();
        List containers = model.getContainers();
        boolean ENABLE_FOLDING = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorFoldingEnable");
        boolean FOLD_COMMENTS = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorFoldingInitiallyFoldComments");
        boolean FOLD_RECORDS = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditoroldingInitiallyFoldRecords");
        boolean FOLD_WRAPPEDLINES = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorFoldingInitiallyFoldWrappedLines");
        if (ENABLE_FOLDING) {
            for (LdifContainer ldifContainer : containers) {
                ProjectionAnnotation annotation;
                Position position;
                int containerStartLine = document.getLineOfOffset(ldifContainer.getOffset());
                int containerEndLine = -1;
                LdifPart[] parts = ldifContainer.getParts();
                int j = parts.length - 1;
                while (j >= 0) {
                    LdifNonEmptyLineBase line;
                    if (containerEndLine == -1 && (!(parts[j] instanceof LdifSepLine) || ldifContainer instanceof LdifCommentContainer && j < parts.length - 1)) {
                        containerEndLine = document.getLineOfOffset(parts[j].getOffset() + parts[j].getLength() - 1);
                    }
                    if (parts[j] instanceof LdifNonEmptyLineBase && (line = (LdifNonEmptyLineBase)parts[j]).isFolded()) {
                        position = new Position(line.getOffset(), line.getLength());
                        annotation = new ProjectionAnnotation(FOLD_WRAPPEDLINES);
                        positionToAnnotationMap.put(position, annotation);
                    }
                    --j;
                }
                if (containerStartLine >= containerEndLine) continue;
                int start = document.getLineOffset(containerStartLine);
                int end = document.getLineOffset(containerEndLine) + document.getLineLength(containerEndLine);
                position = new Position(start, end - start);
                annotation = new ProjectionAnnotation(FOLD_RECORDS || FOLD_COMMENTS && ldifContainer instanceof LdifCommentContainer);
                positionToAnnotationMap.put(position, annotation);
            }
        }
        return positionToAnnotationMap;
    }
}

