/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import javax.naming.InvalidNameException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.connection.core.Messages;

public class DnUtils {
    public static Dn getPrefixName(Dn dn, Dn suffix) {
        if (suffix.size() < 1) {
            return null;
        }
        try {
            Dn prefix = dn.getDescendantOf(suffix);
            return prefix;
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            return null;
        }
    }

    public static Rdn composeRdn(String[] rdnTypes, String[] rdnValues) throws InvalidNameException {
        try {
            Ava[] avas = new Ava[rdnTypes.length];
            int i = 0;
            while (i < rdnTypes.length) {
                avas[i] = new Ava(rdnTypes[i], rdnValues[i]);
                ++i;
            }
            Rdn rdn = new Rdn(avas);
            return rdn;
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            throw new InvalidNameException(Messages.error__invalid_rdn);
        }
    }
}

