/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.studio.connection.ui.actions.ActionHandlerManager;
import org.apache.directory.studio.connection.ui.actions.CloseConnectionAction;
import org.apache.directory.studio.connection.ui.actions.CollapseAllAction;
import org.apache.directory.studio.connection.ui.actions.ConnectionViewActionProxy;
import org.apache.directory.studio.connection.ui.actions.CopyAction;
import org.apache.directory.studio.connection.ui.actions.DeleteAction;
import org.apache.directory.studio.connection.ui.actions.ExpandAllAction;
import org.apache.directory.studio.connection.ui.actions.NewConnectionAction;
import org.apache.directory.studio.connection.ui.actions.NewConnectionFolderAction;
import org.apache.directory.studio.connection.ui.actions.OpenConnectionAction;
import org.apache.directory.studio.connection.ui.actions.PasteAction;
import org.apache.directory.studio.connection.ui.actions.PropertiesAction;
import org.apache.directory.studio.connection.ui.actions.RenameAction;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.apache.directory.studio.connection.ui.dnd.ConnectionTransfer;
import org.apache.directory.studio.connection.ui.dnd.DragConnectionListener;
import org.apache.directory.studio.connection.ui.dnd.DropConnectionListener;
import org.apache.directory.studio.connection.ui.widgets.ConnectionConfiguration;
import org.apache.directory.studio.connection.ui.widgets.ConnectionWidget;
import org.apache.directory.studio.utils.ActionUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class ConnectionActionGroup
implements ActionHandlerManager,
IMenuListener {
    private CollapseAllAction collapseAllAction;
    private ExpandAllAction expandAllAction;
    protected static final String NEW_CONNECTION_ACTION = "newConnectionAction";
    protected static final String NEW_CONNECTION_FOLDER_ACTION = "newConnectionFolderAction";
    protected static final String OPEN_CONNECTION_ACTION = "openConnectionAction";
    protected static final String CLOSE_CONNECTION_ACTION = "closeConnectionAction";
    protected static final String COPY_CONNECTION_ACTION = "copyConnectionAction";
    protected static final String PASTE_CONNECTION_ACTION = "pasteConnectionAction";
    protected static final String DELETE_CONNECTION_ACTION = "deleteConnectionAction";
    protected static final String RENAME_CONNECTION_ACTION = "renameConnectionAction";
    protected static final String PROPERTY_DIALOG_ACTION = "propertyDialogAction";
    private DragConnectionListener dragConnectionListener;
    private DropConnectionListener dropConnectionListener;
    protected Map<String, ConnectionViewActionProxy> connectionActionMap;
    protected IActionBars actionBars;
    protected ConnectionWidget mainWidget;

    public ConnectionActionGroup(ConnectionWidget mainWidget, ConnectionConfiguration configuration) {
        this.mainWidget = mainWidget;
        TreeViewer viewer = mainWidget.getViewer();
        this.collapseAllAction = new CollapseAllAction(viewer);
        this.expandAllAction = new ExpandAllAction(viewer);
        this.connectionActionMap = new HashMap<String, ConnectionViewActionProxy>();
        this.connectionActionMap.put(NEW_CONNECTION_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new NewConnectionAction()));
        this.connectionActionMap.put(NEW_CONNECTION_FOLDER_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new NewConnectionFolderAction()));
        this.connectionActionMap.put(OPEN_CONNECTION_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new OpenConnectionAction()));
        this.connectionActionMap.put(CLOSE_CONNECTION_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new CloseConnectionAction()));
        this.connectionActionMap.put(PASTE_CONNECTION_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new PasteAction()));
        this.connectionActionMap.put(COPY_CONNECTION_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new CopyAction(this.connectionActionMap.get(PASTE_CONNECTION_ACTION))));
        this.connectionActionMap.put(DELETE_CONNECTION_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new DeleteAction()));
        this.connectionActionMap.put(RENAME_CONNECTION_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new RenameAction()));
        this.connectionActionMap.put(PROPERTY_DIALOG_ACTION, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new PropertiesAction()));
        this.dropConnectionListener = new DropConnectionListener();
        this.dragConnectionListener = new DragConnectionListener(viewer);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{ConnectionTransfer.getInstance()};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)this.dragConnectionListener);
        viewer.addDropSupport(ops, transfers, (DropTargetListener)this.dropConnectionListener);
    }

    public void dispose() {
        if (this.mainWidget != null) {
            Iterator<String> it = this.connectionActionMap.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                ConnectionViewActionProxy action = this.connectionActionMap.get(key);
                action.dispose();
                it.remove();
            }
            this.collapseAllAction.dispose();
            this.collapseAllAction = null;
            this.expandAllAction.dispose();
            this.expandAllAction = null;
            this.connectionActionMap.clear();
            this.connectionActionMap = null;
            this.actionBars = null;
            this.mainWidget = null;
            this.dragConnectionListener = null;
            this.dropConnectionListener = null;
        }
    }

    public void enableGlobalActionHandlers(IActionBars actionBars) {
        this.actionBars = actionBars;
        this.activateGlobalActionHandlers();
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.connectionActionMap.get(NEW_CONNECTION_ACTION));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.connectionActionMap.get(OPEN_CONNECTION_ACTION));
        toolBarManager.add((IAction)this.connectionActionMap.get(CLOSE_CONNECTION_ACTION));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.expandAllAction);
        toolBarManager.add((IAction)this.collapseAllAction);
        toolBarManager.update(true);
    }

    public void fillMenu(IMenuManager menuManager) {
    }

    public void fillContextMenu(IMenuManager menuManager) {
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.connectionActionMap.get(NEW_CONNECTION_ACTION));
        menuManager.add((IAction)this.connectionActionMap.get(NEW_CONNECTION_FOLDER_ACTION));
        menuManager.add((IContributionItem)new Separator());
        if (this.connectionActionMap.get(CLOSE_CONNECTION_ACTION).isEnabled()) {
            menuManager.add((IAction)this.connectionActionMap.get(CLOSE_CONNECTION_ACTION));
        } else if (this.connectionActionMap.get(OPEN_CONNECTION_ACTION).isEnabled()) {
            menuManager.add((IAction)this.connectionActionMap.get(OPEN_CONNECTION_ACTION));
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.connectionActionMap.get(COPY_CONNECTION_ACTION));
        menuManager.add((IAction)this.connectionActionMap.get(PASTE_CONNECTION_ACTION));
        menuManager.add((IAction)this.connectionActionMap.get(DELETE_CONNECTION_ACTION));
        menuManager.add((IAction)this.connectionActionMap.get(RENAME_CONNECTION_ACTION));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.connectionActionMap.get(PROPERTY_DIALOG_ACTION));
    }

    @Override
    public void activateGlobalActionHandlers() {
        if (this.actionBars == null) {
            IAction copyConnectionAction = (IAction)this.connectionActionMap.get(COPY_CONNECTION_ACTION);
            copyConnectionAction.setActionDefinitionId("org.apache.directory.studio.ldapbrowser.action.copy");
            ActionUtils.activateActionHandler(copyConnectionAction);
            IAction pasteConnectionAction = (IAction)this.connectionActionMap.get(PASTE_CONNECTION_ACTION);
            pasteConnectionAction.setActionDefinitionId("org.apache.directory.studio.ldapbrowser.action.paste");
            ActionUtils.activateActionHandler(pasteConnectionAction);
            IAction deleteConnectionAction = (IAction)this.connectionActionMap.get(DELETE_CONNECTION_ACTION);
            deleteConnectionAction.setActionDefinitionId("org.apache.directory.studio.ldapbrowser.action.delete");
            ActionUtils.activateActionHandler(deleteConnectionAction);
            IAction propertyDialogAction = (IAction)this.connectionActionMap.get(PROPERTY_DIALOG_ACTION);
            propertyDialogAction.setActionDefinitionId("org.apache.directory.studio.ldapbrowser.action.properties");
            ActionUtils.activateActionHandler(propertyDialogAction);
        } else {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.connectionActionMap.get(COPY_CONNECTION_ACTION));
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.connectionActionMap.get(PASTE_CONNECTION_ACTION));
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.connectionActionMap.get(DELETE_CONNECTION_ACTION));
            this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.connectionActionMap.get(RENAME_CONNECTION_ACTION));
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.connectionActionMap.get(PROPERTY_DIALOG_ACTION));
            this.actionBars.updateActionBars();
        }
    }

    @Override
    public void deactivateGlobalActionHandlers() {
        if (this.actionBars == null) {
            IAction copyConnectionAction = (IAction)this.connectionActionMap.get(COPY_CONNECTION_ACTION);
            ActionUtils.deactivateActionHandler(copyConnectionAction);
            IAction pasteConnectionAction = (IAction)this.connectionActionMap.get(PASTE_CONNECTION_ACTION);
            ActionUtils.deactivateActionHandler(pasteConnectionAction);
            IAction deleteConnectionAction = (IAction)this.connectionActionMap.get(DELETE_CONNECTION_ACTION);
            ActionUtils.deactivateActionHandler(deleteConnectionAction);
            IAction propertyDialogAction = (IAction)this.connectionActionMap.get(PROPERTY_DIALOG_ACTION);
            ActionUtils.deactivateActionHandler(propertyDialogAction);
        } else {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), null);
            this.actionBars.updateActionBars();
        }
    }
}

