/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Messages;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.eclipse.osgi.util.NLS;

public class DependenciesComputer {
    private List<Schema> schemasList;
    private List<Schema> dependencyOrderedSchemasList;
    private SchemaHandler schemaHandler;
    private MultiValuedMap schemasDependencies;
    private MultiValuedMap attributeTypesDependencies;
    private MultiValuedMap objectClassesDependencies;

    public DependenciesComputer(List<Schema> schemas) throws DependencyComputerException {
        this.schemasList = schemas;
        this.schemaHandler = new SchemaHandler();
        this.schemasDependencies = new ArrayListValuedHashMap();
        this.attributeTypesDependencies = new ArrayListValuedHashMap();
        this.objectClassesDependencies = new ArrayListValuedHashMap();
        if (schemas != null) {
            for (Schema schema : this.schemasList) {
                this.schemaHandler.addSchema(schema);
            }
            for (Schema schema : this.schemasList) {
                List<ObjectClass> objectClasses;
                List<AttributeType> attributeTypes = schema.getAttributeTypes();
                if (attributeTypes != null) {
                    for (AttributeType attributeType : attributeTypes) {
                        this.computeDependencies(schema, attributeType);
                    }
                }
                if ((objectClasses = schema.getObjectClasses()) == null) continue;
                for (ObjectClass objectClass : objectClasses) {
                    this.computeDependencies(schema, objectClass);
                }
            }
            this.orderSchemasBasedOnDependencies();
        }
    }

    private void computeDependencies(Schema schema, AttributeType attributeType) throws DependencyComputerException {
        String substringName;
        String orderingName;
        String equalityName;
        String syntaxOID;
        String superior = attributeType.getSuperiorOid();
        if (superior != null) {
            AttributeType superiorAT = this.schemaHandler.getAttributeType(superior);
            if (superiorAT == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.SuperiorAttribute"), (Object[])new String[]{superior}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)superiorAT);
            this.computeSchemaDependency(schema, (SchemaObject)superiorAT);
        }
        if ((syntaxOID = attributeType.getSyntaxOid()) != null) {
            LdapSyntax syntax = this.schemaHandler.getSyntax(syntaxOID);
            if (syntax == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.SyntaxOID"), (Object[])new String[]{syntaxOID}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)syntax);
            this.computeSchemaDependency(schema, (SchemaObject)syntax);
        }
        if ((equalityName = attributeType.getEqualityOid()) != null) {
            MatchingRule equalityMatchingRule = this.schemaHandler.getMatchingRule(equalityName);
            if (equalityMatchingRule == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Equality"), (Object[])new String[]{equalityName}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)equalityMatchingRule);
            this.computeSchemaDependency(schema, (SchemaObject)equalityMatchingRule);
        }
        if ((orderingName = attributeType.getOrderingOid()) != null) {
            MatchingRule orderingMatchingRule = this.schemaHandler.getMatchingRule(orderingName);
            if (orderingMatchingRule == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Ordering"), (Object[])new String[]{orderingName}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)orderingMatchingRule);
            this.computeSchemaDependency(schema, (SchemaObject)orderingMatchingRule);
        }
        if ((substringName = attributeType.getSubstringOid()) != null) {
            MatchingRule substringMatchingRule = this.schemaHandler.getMatchingRule(substringName);
            if (substringMatchingRule == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Substring"), (Object[])new String[]{substringName}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)substringMatchingRule);
            this.computeSchemaDependency(schema, (SchemaObject)substringMatchingRule);
        }
    }

    private void computeDependencies(Schema schema, ObjectClass objectClass) throws DependencyComputerException {
        List mandatoryAttributeTypes;
        List optionalAttributeTypes;
        List superClassesNames = objectClass.getSuperiorOids();
        if (superClassesNames != null) {
            for (String superClassName : superClassesNames) {
                ObjectClass superObjectClass = this.schemaHandler.getObjectClass(superClassName);
                if (superObjectClass == null) {
                    throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.SuperiorObject"), (Object[])new String[]{superClassName}));
                }
                this.objectClassesDependencies.put((Object)objectClass, (Object)superObjectClass);
                this.computeSchemaDependency(schema, (SchemaObject)superObjectClass);
            }
        }
        if ((optionalAttributeTypes = objectClass.getMayAttributeTypeOids()) != null) {
            for (String optionalAttributeTypeName : optionalAttributeTypes) {
                AttributeType optionalAttributeType = this.schemaHandler.getAttributeType(optionalAttributeTypeName);
                if (optionalAttributeType == null) {
                    throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Optional"), (Object[])new Object[]{optionalAttributeType}));
                }
                this.objectClassesDependencies.put((Object)objectClass, (Object)optionalAttributeType);
                this.computeSchemaDependency(schema, (SchemaObject)optionalAttributeType);
            }
        }
        if ((mandatoryAttributeTypes = objectClass.getMustAttributeTypeOids()) != null) {
            for (String mandatoryAttributeTypeName : mandatoryAttributeTypes) {
                AttributeType mandatoryAttributeType = this.schemaHandler.getAttributeType(mandatoryAttributeTypeName);
                if (mandatoryAttributeType == null) {
                    throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Mandatory"), (Object[])new String[]{mandatoryAttributeTypeName}));
                }
                this.objectClassesDependencies.put((Object)objectClass, (Object)mandatoryAttributeType);
                this.computeSchemaDependency(schema, (SchemaObject)mandatoryAttributeType);
            }
        }
    }

    private void computeSchemaDependency(Schema schema, SchemaObject object) throws DependencyComputerException {
        String schemaName = object.getSchemaName();
        if (!schemaName.equalsIgnoreCase(schema.getSchemaName())) {
            Schema schemaFromSuperiorAT = this.schemaHandler.getSchema(schemaName);
            if (schemaFromSuperiorAT == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Schema"), (Object[])new String[]{schemaName}));
            }
            this.schemasDependencies.put((Object)schema, (Object)schemaFromSuperiorAT);
        }
    }

    private void orderSchemasBasedOnDependencies() {
        this.dependencyOrderedSchemasList = new ArrayList<Schema>();
        int counter = 0;
        block0: while (this.dependencyOrderedSchemasList.size() != this.schemasList.size()) {
            Schema schema = this.schemasList.get(counter);
            if (!this.dependencyOrderedSchemasList.contains((Object)schema)) {
                List<Schema> dependencies = this.getDependencies(schema);
                if (dependencies == null) {
                    this.dependencyOrderedSchemasList.add(schema);
                } else {
                    for (Schema dependency : dependencies) {
                        if (this.dependencyOrderedSchemasList.contains((Object)dependency)) continue;
                        ++counter;
                        counter %= this.schemasList.size();
                        continue block0;
                    }
                    this.dependencyOrderedSchemasList.add(schema);
                }
            }
            ++counter;
            counter %= this.schemasList.size();
        }
    }

    public List<Schema> getDependencies(Schema schema) {
        List dependencies = (List)this.schemasDependencies.get((Object)schema);
        HashSet set = new HashSet();
        if (dependencies != null) {
            set.addAll(dependencies);
        }
        return Arrays.asList(set.toArray(new Schema[0]));
    }

    public List<Schema> getDependencyOrderedSchemasList() {
        return this.dependencyOrderedSchemasList;
    }

    public MultiValuedMap getSchemasDependencies() {
        return this.schemasDependencies;
    }

    public MultiValuedMap getAttributeTypesDependencies() {
        return this.attributeTypesDependencies;
    }

    public MultiValuedMap getObjectClassesDependencies() {
        return this.objectClassesDependencies;
    }

    public class DependencyComputerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DependencyComputerException(String message) {
            super(message);
        }
    }
}

