/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.schemamanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.schemamanager.SchemaEditorSchemaLoaderUtils;

public class SchemaEditorSchemaLoader
extends AbstractSchemaLoader {
    private Project project;

    public SchemaEditorSchemaLoader() {
        this.initializeSchemas();
    }

    private void initializeSchemas() {
        this.project = Activator.getDefault().getProjectsHandler().getOpenProject();
        if (this.project != null) {
            List<Schema> schemaObjects = this.project.getSchemaHandler().getSchemas();
            for (Schema schemaObject : schemaObjects) {
                this.schemaMap.put(schemaObject.getSchemaName(), schemaObject);
            }
        }
    }

    public List<Entry> loadComparators(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        return new ArrayList<Entry>();
    }

    public List<Entry> loadSyntaxCheckers(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        return new ArrayList<Entry>();
    }

    public List<Entry> loadNormalizers(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        return new ArrayList<Entry>();
    }

    public List<Entry> loadMatchingRules(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (this.project != null) {
            org.apache.directory.api.ldap.model.schema.registries.Schema[] schemaArray = schemas;
            int n = schemas.length;
            int n2 = 0;
            while (n2 < n) {
                org.apache.directory.api.ldap.model.schema.registries.Schema schema = schemaArray[n2];
                Schema schemaHandlerSchema = this.project.getSchemaHandler().getSchema(schema.getSchemaName());
                if (schemaHandlerSchema != null) {
                    List<MatchingRule> matchingRules = schemaHandlerSchema.getMatchingRules();
                    for (MatchingRule matchingRule : matchingRules) {
                        matchingRuleList.add(SchemaEditorSchemaLoaderUtils.toEntry(matchingRule));
                    }
                }
                ++n2;
            }
        }
        return matchingRuleList;
    }

    public List<Entry> loadSyntaxes(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (this.project != null) {
            org.apache.directory.api.ldap.model.schema.registries.Schema[] schemaArray = schemas;
            int n = schemas.length;
            int n2 = 0;
            while (n2 < n) {
                org.apache.directory.api.ldap.model.schema.registries.Schema schema = schemaArray[n2];
                Schema schemaHandlerSchema = this.project.getSchemaHandler().getSchema(schema.getSchemaName());
                if (schemaHandlerSchema != null) {
                    List<LdapSyntax> syntaxes = schemaHandlerSchema.getSyntaxes();
                    for (LdapSyntax syntax : syntaxes) {
                        syntaxList.add(SchemaEditorSchemaLoaderUtils.toEntry(syntax));
                    }
                }
                ++n2;
            }
        }
        return syntaxList;
    }

    public List<Entry> loadAttributeTypes(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        if (this.project != null) {
            org.apache.directory.api.ldap.model.schema.registries.Schema[] schemaArray = schemas;
            int n = schemas.length;
            int n2 = 0;
            while (n2 < n) {
                org.apache.directory.api.ldap.model.schema.registries.Schema schema = schemaArray[n2];
                Schema schemaHandlerSchema = this.project.getSchemaHandler().getSchema(schema.getSchemaName());
                if (schemaHandlerSchema != null) {
                    List<AttributeType> attributeTypes = schemaHandlerSchema.getAttributeTypes();
                    for (AttributeType attributeType : attributeTypes) {
                        attributeTypeList.add(SchemaEditorSchemaLoaderUtils.toEntry(attributeType));
                    }
                }
                ++n2;
            }
        }
        return attributeTypeList;
    }

    public List<Entry> loadMatchingRuleUses(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        return new ArrayList<Entry>();
    }

    public List<Entry> loadNameForms(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        return new ArrayList<Entry>();
    }

    public List<Entry> loadDitContentRules(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        return new ArrayList<Entry>();
    }

    public List<Entry> loadDitStructureRules(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        return new ArrayList<Entry>();
    }

    public List<Entry> loadObjectClasses(org.apache.directory.api.ldap.model.schema.registries.Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (this.project != null) {
            org.apache.directory.api.ldap.model.schema.registries.Schema[] schemaArray = schemas;
            int n = schemas.length;
            int n2 = 0;
            while (n2 < n) {
                org.apache.directory.api.ldap.model.schema.registries.Schema schema = schemaArray[n2];
                Schema schemaHandlerSchema = this.project.getSchemaHandler().getSchema(schema.getSchemaName());
                if (schemaHandlerSchema != null) {
                    List<ObjectClass> objectClasses = schemaHandlerSchema.getObjectClasses();
                    for (ObjectClass objectClass : objectClasses) {
                        objectClassList.add(SchemaEditorSchemaLoaderUtils.toEntry(objectClass));
                    }
                }
                ++n2;
            }
        }
        return objectClassList;
    }
}

