/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.GenericSchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.view.widget.CoreSchemasSelectionWidget;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.apache.directory.studio.schemaeditor.view.wizards.NewProjectWizardConnectionSelectionPage;
import org.apache.directory.studio.schemaeditor.view.wizards.NewProjectWizardInformationPage;
import org.apache.directory.studio.schemaeditor.view.wizards.NewProjectWizardSchemasSelectionPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    public static final String ID = PluginConstants.NEW_WIZARD_NEW_PROJECT_WIZARD;
    private NewProjectWizardInformationPage informationPage;
    private NewProjectWizardConnectionSelectionPage connectionSelectionPage;
    private NewProjectWizardSchemasSelectionPage schemasSelectionPage;

    public void addPages() {
        this.informationPage = new NewProjectWizardInformationPage();
        this.connectionSelectionPage = new NewProjectWizardConnectionSelectionPage();
        this.schemasSelectionPage = new NewProjectWizardSchemasSelectionPage();
        this.addPage((IWizardPage)this.informationPage);
        this.addPage((IWizardPage)this.connectionSelectionPage);
        this.addPage((IWizardPage)this.schemasSelectionPage);
    }

    public boolean performFinish() {
        String projectName = this.informationPage.getProjectName();
        ProjectType projectType = this.informationPage.getProjectType();
        final Project project = new Project(projectType, projectName);
        if (projectType.equals((Object)ProjectType.ONLINE)) {
            project.setConnection(this.connectionSelectionPage.getSelectedConnection());
            RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)new StudioConnectionRunnableWithProgress(){

                public void run(StudioProgressMonitor monitor) {
                    List correctSchemaConnectors = NewProjectWizard.this.getCorrectSchemaConnectors(project.getConnection(), monitor);
                    if (correctSchemaConnectors.size() == 0) {
                        monitor.reportError("No suitable SchemaConnector has been found for the choosen Directory Server.", (Exception)new NoSuitableSchemaConnectorException());
                    }
                    if (correctSchemaConnectors.size() > 1) {
                        for (SchemaConnector schemaConnector : correctSchemaConnectors) {
                            if (!(schemaConnector instanceof GenericSchemaConnector)) continue;
                            correctSchemaConnectors.remove(schemaConnector);
                            break;
                        }
                    }
                    SchemaConnector correctSchemaConnector = null;
                    if (correctSchemaConnectors.size() == 1) {
                        correctSchemaConnector = (SchemaConnector)correctSchemaConnectors.get(0);
                    }
                    project.setSchemaConnector(correctSchemaConnector);
                    project.fetchOnlineSchema(monitor);
                }

                public String getName() {
                    return Messages.getString("NewProjectWizard.FetchingSchema");
                }

                public Object[] getLockedObjects() {
                    return null;
                }

                public String getErrorMessage() {
                    return Messages.getString("NewProjectWizard.ErrorWhileFetchingSchema");
                }

                public Connection[] getConnections() {
                    return null;
                }
            }, (IRunnableContext)this.getContainer(), (boolean)true);
        } else if (projectType.equals((Object)ProjectType.OFFLINE)) {
            String[] selectedSchemas = this.schemasSelectionPage.getSelectedSchemas();
            CoreSchemasSelectionWidget.ServerTypeEnum serverType = this.schemasSelectionPage.getServerType();
            if (selectedSchemas != null && serverType != null) {
                SchemaHandler schemaHandler = project.getSchemaHandler();
                String[] stringArray = selectedSchemas;
                int n = selectedSchemas.length;
                int n2 = 0;
                while (n2 < n) {
                    String selectedSchema = stringArray[n2];
                    Schema schema = PluginUtils.loadCoreSchema(serverType, selectedSchema);
                    if (schema != null) {
                        schema.setProject(project);
                        schemaHandler.addSchema(schema);
                    }
                    ++n2;
                }
            }
        }
        ProjectsHandler projectsHandler = Activator.getDefault().getProjectsHandler();
        projectsHandler.addProject(project);
        projectsHandler.openProject(project);
        return true;
    }

    private List<SchemaConnector> getCorrectSchemaConnectors(Connection connection, StudioProgressMonitor monitor) {
        ArrayList<SchemaConnector> suitableSchemaConnectors = new ArrayList<SchemaConnector>();
        List<SchemaConnector> schemaConectors = PluginUtils.getSchemaConnectors();
        for (SchemaConnector schemaConnector : schemaConectors) {
            if (!schemaConnector.isSuitableConnector(connection, monitor)) continue;
            suitableSchemaConnectors.add(schemaConnector);
        }
        return suitableSchemaConnectors;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.informationPage)) {
            if (this.informationPage.getProjectType().equals((Object)ProjectType.ONLINE)) {
                return this.connectionSelectionPage;
            }
            if (this.informationPage.getProjectType().equals((Object)ProjectType.OFFLINE)) {
                return this.schemasSelectionPage;
            }
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page.equals((Object)this.connectionSelectionPage) || page.equals((Object)this.schemasSelectionPage)) {
            return this.informationPage;
        }
        return null;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.equals((Object)this.informationPage)) {
            return false;
        }
        if (currentPage.equals((Object)this.schemasSelectionPage)) {
            return true;
        }
        if (currentPage.equals((Object)this.connectionSelectionPage)) {
            return this.connectionSelectionPage.isPageComplete();
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    class NoSuitableSchemaConnectorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NoSuitableSchemaConnectorException() {
        }
    }
}

