/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.Collection;
import org.apache.directory.studio.entryeditors.EntryEditorExtension;
import org.apache.directory.studio.entryeditors.EntryEditorManager;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.apache.directory.studio.ldapbrowser.ui.actions.OpenEntryEditorsPreferencePageAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;

public class EntryEditorMenuManager
extends MenuManager
implements IMenuListener {
    private ISelectionProvider selectionProvider;
    private OpenEntryEditorsPreferencePageAction openEntryEditorsPreferencePageAction;

    public EntryEditorMenuManager(ISelectionProvider selectionProvider) {
        super(Messages.getString("EntryEditorMenuManager.OpenWith"));
        this.selectionProvider = selectionProvider;
        this.openEntryEditorsPreferencePageAction = new OpenEntryEditorsPreferencePageAction();
        this.addMenuListener(this);
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.removeAll();
        IEntry selectedEntry = this.getCurrentSelection();
        if (selectedEntry != null) {
            Collection<EntryEditorExtension> entryEditors = BrowserUIPlugin.getDefault().getEntryEditorManager().getSortedEntryEditorExtensions();
            for (EntryEditorExtension entryEditor : entryEditors) {
                if (!entryEditor.getEditorInstance().canHandle(selectedEntry)) continue;
                this.add(this.createAction(entryEditor));
            }
        }
        this.add((IContributionItem)new Separator());
        this.add((IAction)this.openEntryEditorsPreferencePageAction);
    }

    private IEntry getCurrentSelection() {
        StructuredSelection structuredSelection = (StructuredSelection)this.selectionProvider.getSelection();
        if (!structuredSelection.isEmpty()) {
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof IEntry) {
                return (IEntry)selection;
            }
            if (selection instanceof ISearchResult) {
                return ((ISearchResult)selection).getEntry();
            }
            if (selection instanceof IBookmark) {
                return ((IBookmark)selection).getEntry();
            }
        }
        return null;
    }

    private IAction createAction(final EntryEditorExtension entryEditorExtension) {
        Action action = new Action(entryEditorExtension.getName(), entryEditorExtension.getIcon()){

            public void run() {
                EntryEditorManager entryEditorManager = BrowserUIPlugin.getDefault().getEntryEditorManager();
                ISelection selection = EntryEditorMenuManager.this.selectionProvider.getSelection();
                IEntry[] selectedEntries = BrowserSelectionUtils.getEntries((ISelection)selection);
                ISearchResult[] selectedSearchResults = BrowserSelectionUtils.getSearchResults((ISelection)selection);
                IBookmark[] selectedBookMarks = BrowserSelectionUtils.getBookmarks((ISelection)selection);
                entryEditorManager.openEntryEditor(entryEditorExtension, selectedEntries, selectedSearchResults, selectedBookMarks);
            }
        };
        return action;
    }

    public boolean isVisible() {
        ISelection selection = this.selectionProvider.getSelection();
        IBookmark[] selectedBookMarks = BrowserSelectionUtils.getBookmarks((ISelection)selection);
        IEntry[] selectedEntries = BrowserSelectionUtils.getEntries((ISelection)selection);
        ISearchResult[] selectedSearchResults = BrowserSelectionUtils.getSearchResults((ISelection)selection);
        return selectedSearchResults.length + selectedBookMarks.length + selectedEntries.length == 1;
    }

    public boolean isDynamic() {
        return true;
    }
}

