/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs;

import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequest;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.common.ui.dialogs.MessageDialogWithTextarea;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExtendedOperationRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordModifyExtendedOperationDialog
extends Dialog {
    private IBrowserConnection connection;
    private IEntry entry;
    private Dn userIdentity = null;
    private String oldPassword = "";
    private String newPassword = "";
    private EntryWidget entryWidget;
    private Button useBindUserIdentityCheckbox;
    private Text oldPasswordText;
    private Button noOldPasswordCheckbox;
    private Text newPasswordText;
    private Button generateNewPasswordCheckbox;
    private Button showPasswordsCheckbox;
    private SelectionAdapter useBindUserIdentityCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (PasswordModifyExtendedOperationDialog.this.useBindUserIdentityCheckbox.getSelection()) {
                PasswordModifyExtendedOperationDialog.this.entryWidget.setInput(PasswordModifyExtendedOperationDialog.this.connection, null);
                PasswordModifyExtendedOperationDialog.this.entryWidget.setEnabled(false);
            } else {
                PasswordModifyExtendedOperationDialog.this.entryWidget.setEnabled(true);
            }
            PasswordModifyExtendedOperationDialog.this.validate();
        }
    };
    private SelectionAdapter noOldPasswordCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (PasswordModifyExtendedOperationDialog.this.noOldPasswordCheckbox.getSelection()) {
                PasswordModifyExtendedOperationDialog.this.oldPasswordText.setText("");
                PasswordModifyExtendedOperationDialog.this.oldPasswordText.setEnabled(false);
            } else {
                PasswordModifyExtendedOperationDialog.this.oldPasswordText.setEnabled(true);
            }
            PasswordModifyExtendedOperationDialog.this.validate();
        }
    };
    private SelectionAdapter generateNewPasswordCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (PasswordModifyExtendedOperationDialog.this.generateNewPasswordCheckbox.getSelection()) {
                PasswordModifyExtendedOperationDialog.this.newPasswordText.setText("");
                PasswordModifyExtendedOperationDialog.this.newPasswordText.setEnabled(false);
            } else {
                PasswordModifyExtendedOperationDialog.this.newPasswordText.setEnabled(true);
            }
            PasswordModifyExtendedOperationDialog.this.validate();
        }
    };
    private SelectionAdapter showPasswordsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (PasswordModifyExtendedOperationDialog.this.showPasswordsCheckbox.getSelection()) {
                PasswordModifyExtendedOperationDialog.this.oldPasswordText.setEchoChar('\u0000');
                PasswordModifyExtendedOperationDialog.this.newPasswordText.setEchoChar('\u0000');
            } else {
                PasswordModifyExtendedOperationDialog.this.oldPasswordText.setEchoChar('\u2022');
                PasswordModifyExtendedOperationDialog.this.newPasswordText.setEchoChar('\u2022');
            }
        }
    };

    public PasswordModifyExtendedOperationDialog(Shell parentShell, IBrowserConnection connection, IEntry entry) {
        super(parentShell);
        this.connection = connection;
        this.entry = entry;
        if (entry != null) {
            this.userIdentity = entry.getDn();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("PasswordModifyExtendedOperationDialog.Title"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            PasswordModifyResponse response;
            ProgressMonitorDialog dialog;
            ExtendedOperationRunnable runnable;
            IStatus status;
            this.userIdentity = this.entryWidget.getDn();
            this.oldPassword = this.oldPasswordText.getText();
            this.newPassword = this.newPasswordText.getText();
            LdapApiService ldapApiService = LdapApiServiceFactory.getSingleton();
            PasswordModifyRequest request = (PasswordModifyRequest)((ExtendedOperationFactory)ldapApiService.getExtendedRequestFactories().get("1.3.6.1.4.1.4203.1.11.1")).newRequest();
            if (!this.useBindUserIdentityCheckbox.getSelection()) {
                request.setUserIdentity(Strings.getBytesUtf8((String)this.userIdentity.getName()));
            }
            if (!this.noOldPasswordCheckbox.getSelection()) {
                request.setOldPassword(Strings.getBytesUtf8((String)this.oldPassword));
            }
            if (!this.generateNewPasswordCheckbox.getSelection()) {
                request.setNewPassword(Strings.getBytesUtf8((String)this.newPassword));
            }
            if (!(status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)(runnable = new ExtendedOperationRunnable(this.connection, (ExtendedRequest)request)), (IRunnableContext)(dialog = new ProgressMonitorDialog(this.getShell())), (boolean)true)).isOK()) {
                return;
            }
            if (this.entry != null) {
                EventRegistry.fireEntryUpdated((EntryModificationEvent)new EntryModificationEvent(this.entry.getBrowserConnection(), this.entry), (Object)((Object)this));
            }
            if ((response = (PasswordModifyResponse)runnable.getResponse()).getGenPassword() != null) {
                String generatedPassword = Strings.utf8ToString((byte[])response.getGenPassword());
                new MessageDialogWithTextarea(this.getShell(), Messages.getString("PasswordModifyExtendedOperationDialog.GeneratedPasswordTitle"), Messages.getString("PasswordModifyExtendedOperationDialog.GeneratedPasswordMessage"), generatedPassword).open();
            }
        } else {
            this.userIdentity = null;
            this.oldPassword = null;
            this.newPassword = null;
        }
        super.buttonPressed(buttonId);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.validate();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData compositeGridData = new GridData(4, 4, true, true);
        compositeGridData.widthHint = this.convertHorizontalDLUsToPixels(450);
        composite.setLayoutData((Object)compositeGridData);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("PasswordModifyExtendedOperationDialog.UserIdentity"), (int)1);
        this.entryWidget = new EntryWidget(this.connection, this.userIdentity);
        this.entryWidget.addWidgetModifyListener(event -> this.validate());
        this.entryWidget.createWidget(composite);
        BaseWidgetUtils.createLabel((Composite)composite, (String)"", (int)1);
        this.useBindUserIdentityCheckbox = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("PasswordModifyExtendedOperationDialog.UseBindUserIdentity"), (int)2);
        this.useBindUserIdentityCheckbox.addSelectionListener((SelectionListener)this.useBindUserIdentityCheckboxListener);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("PasswordModifyExtendedOperationDialog.OldPassword"), (int)1);
        this.oldPasswordText = BaseWidgetUtils.createText((Composite)composite, (String)this.oldPassword, (int)2);
        this.oldPasswordText.setEchoChar('\u2022');
        this.oldPasswordText.addModifyListener(event -> this.validate());
        BaseWidgetUtils.createLabel((Composite)composite, (String)"", (int)1);
        this.noOldPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("PasswordModifyExtendedOperationDialog.NoOldPassword"), (int)2);
        this.noOldPasswordCheckbox.addSelectionListener((SelectionListener)this.noOldPasswordCheckboxListener);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("PasswordModifyExtendedOperationDialog.NewPassword"), (int)1);
        this.newPasswordText = BaseWidgetUtils.createText((Composite)composite, (String)this.newPassword, (int)2);
        this.newPasswordText.setEchoChar('\u2022');
        this.newPasswordText.addModifyListener(event -> this.validate());
        BaseWidgetUtils.createLabel((Composite)composite, (String)"", (int)1);
        this.generateNewPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("PasswordModifyExtendedOperationDialog.GenerateNewPassword"), (int)2);
        this.generateNewPasswordCheckbox.addSelectionListener((SelectionListener)this.generateNewPasswordCheckboxListener);
        BaseWidgetUtils.createLabel((Composite)composite, (String)"", (int)1);
        this.showPasswordsCheckbox = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("PasswordModifyExtendedOperationDialog.ShowPasswords"), (int)2);
        this.showPasswordsCheckbox.addSelectionListener((SelectionListener)this.showPasswordsCheckboxListener);
        PasswordModifyExtendedOperationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void validate() {
        if (this.getButton(0) != null) {
            boolean userIdentityInputValid = this.useBindUserIdentityCheckbox.getSelection() || this.entryWidget.getDn() != null && !this.entryWidget.getDn().isEmpty();
            boolean oldPasswordInputValid = this.noOldPasswordCheckbox.getSelection() || !this.oldPasswordText.getText().isEmpty();
            boolean newPasswordInputValid = this.generateNewPasswordCheckbox.getSelection() || !this.newPasswordText.getText().isEmpty();
            this.getButton(0).setEnabled(userIdentityInputValid && oldPasswordInputValid && newPasswordInputValid);
        }
    }

    public Dn getUserIdentity() {
        return this.userIdentity;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }
}

