/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditorShowInMenuManager;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.Messages;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LocateEntryInLdapBrowserAction
extends Action {
    protected EntryEditor entryEditor;
    protected EntryEditorShowInMenuManager showInMenuManager;

    public LocateEntryInLdapBrowserAction(EntryEditor entryEditor, EntryEditorShowInMenuManager showInMenuManager) {
        this.entryEditor = entryEditor;
        this.showInMenuManager = showInMenuManager;
    }

    public void run() {
        IEntry entry;
        EntryEditorInput editorInput;
        if (this.entryEditor != null && (editorInput = this.entryEditor.getEntryEditorInput()) != null && (entry = editorInput.getResolvedEntry()) != null) {
            this.select(entry);
        }
    }

    protected void select(Object o) {
        String targetId = BrowserView.getId();
        IViewPart targetView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(targetId);
        if (targetView == null) {
            try {
                targetView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(targetId, null, 1);
            }
            catch (PartInitException partInitException) {}
        }
        if (targetView instanceof BrowserView) {
            ((BrowserView)targetView).select(o);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)targetView);
        }
    }

    public String getText() {
        return Messages.getString("LocateEntryInLdapBrowserAction.LDAPBrowser");
    }

    public String getToolTipText() {
        return this.getText();
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/locate_entry_in_dit.gif");
    }
}

