/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.LdapSyntaxDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class LdapSyntaxDescriptionPage
extends SchemaPage {
    public LdapSyntaxDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    @Override
    protected String getTitle() {
        return Messages.getString("LdapSyntaxDescriptionPage.Syntaxes");
    }

    @Override
    protected String getFilterDescription() {
        return Messages.getString("LdapSyntaxDescriptionPage.SelectASyntax");
    }

    @Override
    protected IStructuredContentProvider getContentProvider() {
        return new LSDContentProvider();
    }

    @Override
    protected ITableLabelProvider getLabelProvider() {
        return new LSDLabelProvider();
    }

    @Override
    protected ViewerSorter getSorter() {
        return new LSDViewerSorter();
    }

    @Override
    protected ViewerFilter getFilter() {
        return new LSDViewerFilter();
    }

    @Override
    protected SchemaDetailsPage getDetailsPage() {
        return new LdapSyntaxDescriptionDetailsPage(this, this.toolkit);
    }

    class LSDContentProvider
    implements IStructuredContentProvider {
        LSDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null && schema.getLdapSyntaxDescriptions() != null) {
                return schema.getLdapSyntaxDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LSDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        LSDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof LdapSyntax) {
                return SchemaUtils.toString((AbstractSchemaObject)((LdapSyntax)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class LSDViewerFilter
    extends ViewerFilter {
        LSDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof LdapSyntax) {
                LdapSyntax lsd = (LdapSyntax)element;
                boolean matched = Strings.toLowerCase((String)SchemaUtils.toString((AbstractSchemaObject)lsd)).indexOf(Strings.toLowerCase((String)LdapSyntaxDescriptionPage.this.filterText.getText())) != -1 || Strings.toLowerCase((String)lsd.getOid()).indexOf(Strings.toLowerCase((String)LdapSyntaxDescriptionPage.this.filterText.getText())) != -1;
                return matched;
            }
            return false;
        }
    }

    class LSDViewerSorter
    extends ViewerSorter {
        LSDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof LdapSyntax) {
                e1 = SchemaUtils.toString((AbstractSchemaObject)((LdapSyntax)e1));
            }
            if (e2 instanceof LdapSyntax) {
                e2 = SchemaUtils.toString((AbstractSchemaObject)((LdapSyntax)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }
}

