/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import java.util.Collection;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.DnBuilderWidget;
import org.apache.directory.studio.ldapbrowser.core.jobs.EntryExistsCopyStrategyDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class EntryExistsCopyStrategyDialogImpl
extends Dialog
implements EntryExistsCopyStrategyDialog {
    private String dialogTitle = Messages.getString("EntryExistsCopyStrategyDialogImpl.SelectCopyStrategy");
    private Button breakButton;
    private Button ignoreButton;
    private Button overwriteButton;
    private Button renameButton;
    private DnBuilderWidget dnBuilderWidget;
    private Rdn rdn;
    private EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy strategy;
    private boolean isRememberStrategy;
    private IBrowserConnection browserConnection;
    private Dn dn;

    public EntryExistsCopyStrategyDialogImpl(Shell parentShell) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.strategy = EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy.BREAK;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected void okPressed() {
        this.rdn = null;
        if (this.breakButton.getSelection()) {
            this.strategy = EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy.BREAK;
        } else if (this.ignoreButton.getSelection()) {
            this.strategy = EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy.IGNORE_AND_CONTINUE;
        } else if (this.overwriteButton.getSelection()) {
            this.strategy = EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy.OVERWRITE_AND_CONTINUE;
        } else if (this.renameButton.getSelection()) {
            this.strategy = EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy.RENAME_AND_CONTINUE;
            this.rdn = this.dnBuilderWidget.getRdn();
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        String text = NLS.bind((String)Messages.getString("EntryExistsCopyStrategyDialogImpl.SelectCopyStrategyDescription"), (Object)this.dn.getName());
        BaseWidgetUtils.createLabel((Composite)composite, (String)text, (int)1);
        Group group2 = BaseWidgetUtils.createGroup((Composite)composite, (String)"", (int)1);
        Composite group = BaseWidgetUtils.createColumnContainer((Composite)group2, (int)2, (int)1);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryExistsCopyStrategyDialogImpl.this.validate();
            }
        };
        this.breakButton = BaseWidgetUtils.createRadiobutton((Composite)group, (String)Messages.getString("EntryExistsCopyStrategyDialogImpl.StopCopyProcess"), (int)2);
        this.breakButton.setSelection(true);
        this.breakButton.addSelectionListener((SelectionListener)listener);
        this.ignoreButton = BaseWidgetUtils.createRadiobutton((Composite)group, (String)Messages.getString("EntryExistsCopyStrategyDialogImpl.IgnoreEntryAndContinue"), (int)2);
        this.ignoreButton.addSelectionListener((SelectionListener)listener);
        this.overwriteButton = BaseWidgetUtils.createRadiobutton((Composite)group, (String)Messages.getString("EntryExistsCopyStrategyDialogImpl.OverwriteEntryAndContinue"), (int)2);
        this.overwriteButton.addSelectionListener((SelectionListener)listener);
        this.renameButton = BaseWidgetUtils.createRadiobutton((Composite)group, (String)Messages.getString("EntryExistsCopyStrategyDialogImpl.RenameEntryAndContinue"), (int)2);
        this.renameButton.addSelectionListener((SelectionListener)listener);
        BaseWidgetUtils.createRadioIndent((Composite)group, (int)1);
        this.dnBuilderWidget = new DnBuilderWidget(true, false);
        this.dnBuilderWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                EntryExistsCopyStrategyDialogImpl.this.validate();
            }
        });
        this.dnBuilderWidget.createContents(group);
        this.dnBuilderWidget.setInput(this.browserConnection, SchemaUtils.getNamesAsArray((Collection)this.browserConnection.getSchema().getAttributeTypeDescriptions()), this.dn.getRdn(), null);
        this.validate();
        EntryExistsCopyStrategyDialogImpl.applyDialogFont((Control)composite);
        return composite;
    }

    private void validate() {
        if (this.renameButton.getSelection()) {
            this.dnBuilderWidget.setEnabled(true);
            this.getButton(0).setEnabled(this.dnBuilderWidget.getRdn() != null);
        } else {
            this.dnBuilderWidget.setEnabled(false);
        }
    }

    public int open() {
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = EntryExistsCopyStrategyDialogImpl.super.open();
            }
        });
        return result[0];
    }

    public EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy getStrategy() {
        return this.strategy;
    }

    public Rdn getRdn() {
        return this.rdn;
    }

    public boolean isRememberSelection() {
        return this.isRememberStrategy;
    }

    public void setExistingEntry(IBrowserConnection browserConnection, Dn dn) {
        this.browserConnection = browserConnection;
        this.dn = dn;
    }
}

