/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.wizards.AttributeOptionsWizardPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.AttributeTypeWizardPage;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class AttributeWizard
extends Wizard
implements INewWizard {
    private AttributeTypeWizardPage typePage;
    private AttributeOptionsWizardPage optionsPage;
    private boolean initialShowSubschemaAttributesOnly;
    private boolean initialHideExistingAttributes;
    private String initialAttributeDescription;
    private IEntry initialEntry;
    private String finalAttributeDescription = null;

    public AttributeWizard() {
        super.setWindowTitle(Messages.getString("AttributeWizard.NewAttribute"));
        super.setNeedsProgressMonitor(false);
        this.initialShowSubschemaAttributesOnly = true;
        this.initialHideExistingAttributes = true;
        this.initialAttributeDescription = "";
        this.initialEntry = null;
    }

    public AttributeWizard(String title, boolean showSubschemaAttributesOnly, boolean hideExistingAttributes, String attributeDescription, IEntry entry) {
        super.setWindowTitle(title);
        super.setNeedsProgressMonitor(false);
        this.initialShowSubschemaAttributesOnly = showSubschemaAttributesOnly;
        this.initialHideExistingAttributes = hideExistingAttributes;
        this.initialAttributeDescription = attributeDescription;
        this.initialEntry = entry;
    }

    public static String getId() {
        return BrowserCommonConstants.WIZARD_ATTRIBUTE_WIZARD;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (this.initialEntry != null) {
            this.typePage = new AttributeTypeWizardPage(AttributeTypeWizardPage.class.getName(), this.initialEntry, this.initialAttributeDescription, this.initialShowSubschemaAttributesOnly, this.initialHideExistingAttributes, this);
            this.addPage((IWizardPage)this.typePage);
            this.optionsPage = new AttributeOptionsWizardPage(AttributeOptionsWizardPage.class.getName(), this.initialAttributeDescription, this);
            this.addPage((IWizardPage)this.optionsPage);
        } else {
            DummyWizardPage page = new DummyWizardPage();
            this.addPage((IWizardPage)page);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.typePage.getControl(), String.valueOf(BrowserCommonConstants.PLUGIN_ID) + "." + "tools_attribute_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.optionsPage.getControl(), String.valueOf(BrowserCommonConstants.PLUGIN_ID) + "." + "tools_attribute_wizard");
    }

    public boolean performFinish() {
        this.finalAttributeDescription = this.getAttributeDescription();
        return true;
    }

    public String getAttributeDescription() {
        if (this.finalAttributeDescription != null) {
            return this.finalAttributeDescription;
        }
        return String.valueOf(this.typePage.getAttributeType()) + this.optionsPage.getAttributeOptions();
    }

    class DummyWizardPage
    extends WizardPage {
        protected DummyWizardPage() {
            super("");
            super.setTitle(Messages.getString("AttributeWizard.NoEntrySelected"));
            super.setDescription(Messages.getString("AttributeWizard.NoeEntrySelectedDescription"));
            super.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            composite.setLayout((Layout)gl);
            composite.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)composite);
        }
    }
}

