/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final long MILLIS_IN_DAY = 86400000L;
    private static Map<Locale, DateFormatSymbols> sdfMap = new HashMap<Locale, DateFormatSymbols>();
    public static final String FORMAT_PATTERN_ISO_DATE = "yyyy-MM-dd";
    public static final String FORMAT_PATTERN_ISO_TIME = "HH:mm:ss";
    public static final String FORMAT_PATTERN_ISO_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_PATTERN_ISO_TIMESTAMP = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_PATTERN_ISO_TIMESTAMP6 = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final String FORMAT_PATTERN_ISO_TIMESTAMP9 = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    private static final Map<String, DateTimeFormatter> patternFormatterMap = new ConcurrentHashMap<String, DateTimeFormatter>();

    private DateUtils() {
    }

    public static java.util.Date getDateNow() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getTimeNow() {
        return Calendar.getInstance().getTime();
    }

    public static Timestamp getTimestamp() {
        LocalDateTime ts = LocalDateTime.now();
        int nano = ts.getNano();
        int remain = nano % 1000;
        if (remain > 0) {
            ts = LocalDateTime.of(ts.getYear(), ts.getMonth(), ts.getDayOfMonth(), ts.getHour(), ts.getMinute(), ts.getSecond(), nano - remain);
        }
        return Timestamp.valueOf(ts);
    }

    public static java.util.Date addDate(java.util.Date date, int years, int months, int days) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (years != 0) {
            calendar.add(1, years);
        }
        if (months != 0) {
            calendar.add(2, months);
        }
        if (days != 0) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static java.util.Date setDate(java.util.Date date, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month > 0) {
            calendar.set(2, month - 1);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        return calendar.getTime();
    }

    public static java.util.Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month > 0) {
            calendar.set(2, month - 1);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getDateTime(int year, int month, int day, int hours, int minutes, int seconds, int millis) {
        Calendar calendar = Calendar.getInstance();
        if (year > 0) {
            calendar.set(1, year);
        }
        if (month > 0) {
            calendar.set(2, month - 1);
        }
        if (day > 0) {
            calendar.set(5, day);
        }
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, millis);
        return calendar.getTime();
    }

    public static java.util.Date getDateTime(int year, int month, int day, int hours, int minutes, int seconds) {
        return DateUtils.getDateTime(year, month, day, hours, minutes, seconds, 0);
    }

    public static java.util.Date setTime(java.util.Date date, int hours, int minutes, int seconds, int millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, millis);
        return calendar.getTime();
    }

    public static java.util.Date getDateOnly(java.util.Date date) {
        return DateUtils.setTime(date, 0, 0, 0, 0);
    }

    public static java.util.Date getTimeOnly(java.util.Date date) {
        return DateUtils.setDate(date, 0, 0, 0);
    }

    public static long compareDates(java.util.Date date1, java.util.Date date2) {
        long time1 = DateUtils.setTime(date1, 0, 0, 0, 0).getTime();
        long time2 = DateUtils.setTime(date2, 0, 0, 0, 0).getTime();
        return (time1 /= 86400000L) - (time2 /= 86400000L);
    }

    public static boolean compareEqual(java.util.Date date1, java.util.Date date2) {
        return DateUtils.compareDates(date1, date2) == 0L;
    }

    public static int getDaysBetween(java.util.Date date1, java.util.Date date2) {
        if (date1 == null) {
            date1 = DateUtils.getDateNow();
        }
        if (date2 == null) {
            date2 = DateUtils.getDateNow();
        }
        long diffInMillies = date2.getTime() - date1.getTime();
        return (int)TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getYear(java.util.Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.YEAR);
    }

    public static int getMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int getMonth(java.util.Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.MONTH_OF_YEAR);
    }

    public static int getDay() {
        return Calendar.getInstance().get(5);
    }

    public static int getDay(java.util.Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.DAY_OF_MONTH);
    }

    public static int getDayOfWeek() {
        int dow = Calendar.getInstance().get(7) - 1;
        return dow <= 0 ? 7 : dow;
    }

    public static int getDayOfWeek(java.util.Date date) {
        ZonedDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return dateTime.get(ChronoField.DAY_OF_WEEK);
    }

    public static int getWeekOfYear(java.util.Date date, Locale locale) {
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        return c.get(3);
    }

    public static java.util.Date parseDate(String sDate, Locale locale) {
        try {
            DateFormat df = DateFormat.getDateInstance(3, DateUtils.getSafeLocale(locale));
            df.setLenient(true);
            return df.parse(sDate);
        }
        catch (ParseException e) {
            log.error("Invalid date value", (Throwable)e);
            return null;
        }
    }

    private static Locale getSafeLocale(Locale locale) {
        return locale == null ? Locale.getDefault() : locale;
    }

    public static String formatDate(java.util.Date date, Locale locale) {
        if (date == null) {
            return "";
        }
        DateFormat df = DateFormat.getDateInstance(2, DateUtils.getSafeLocale(locale));
        return df.format(date);
    }

    public static String formatTime(java.util.Date date, Locale locale, boolean withSeconds) {
        if (date == null) {
            return "";
        }
        int style = withSeconds ? 2 : 3;
        DateFormat df = DateFormat.getTimeInstance(style, DateUtils.getSafeLocale(locale));
        return df.format(date);
    }

    public static synchronized DateFormatSymbols getDateFormatSymbols(Locale locale) {
        DateFormatSymbols dfs;
        if (locale == null) {
            locale = DateUtils.getSafeLocale(locale);
        }
        if ((dfs = sdfMap.get(locale)) == null) {
            dfs = new DateFormatSymbols(locale);
            sdfMap.put(locale, dfs);
        }
        return dfs;
    }

    public static String formatDayOfWeek(java.util.Date date, Locale locale, boolean longFormat) {
        if (date == null) {
            return "";
        }
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        int dayOfWeek = c.get(7) - 1;
        return DateUtils.formatDayOfWeek(dayOfWeek == 0 ? 7 : dayOfWeek, locale, longFormat);
    }

    public static String formatDayOfWeek(Temporal date, Locale locale, boolean longFormat) {
        if (date == null) {
            return "";
        }
        int dayOfWeek = date.get(ChronoField.DAY_OF_WEEK);
        return DateUtils.formatDayOfWeek(dayOfWeek, locale, longFormat);
    }

    public static String formatDayOfWeek(int dayOfWeek, Locale locale, boolean longFormat) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            return "";
        }
        if (dayOfWeek == 7) {
            dayOfWeek = 0;
        }
        DateFormatSymbols dfs = DateUtils.getDateFormatSymbols(locale);
        if (longFormat) {
            return dfs.getWeekdays()[dayOfWeek + 1];
        }
        return dfs.getShortWeekdays()[dayOfWeek + 1];
    }

    public static String formatMonth(java.util.Date date, Locale locale, boolean longFormat) {
        if (date == null) {
            return "";
        }
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        int month = c.get(2) + 1;
        return DateUtils.formatMonth(month, locale, longFormat);
    }

    public static String formatMonth(Temporal date, Locale locale, boolean longFormat) {
        if (date == null) {
            return "";
        }
        int month = date.get(ChronoField.MONTH_OF_YEAR);
        return DateUtils.formatMonth(month, locale, longFormat);
    }

    public static String formatMonth(int month, Locale locale, boolean longFormat) {
        if (month < 1 || month > 12) {
            return "";
        }
        DateFormatSymbols dfs = DateUtils.getDateFormatSymbols(locale);
        if (longFormat) {
            return dfs.getMonths()[month - 1];
        }
        return dfs.getShortMonths()[month - 1];
    }

    public static String formatYear(java.util.Date date, Locale locale) {
        if (date == null) {
            return "";
        }
        Calendar c = Calendar.getInstance(DateUtils.getSafeLocale(locale));
        c.setTime(date);
        return String.format("%04d", c.get(1));
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toLocalDate();
    }

    public static LocalDate toLocalDate(Timestamp timestamp) {
        return timestamp.toLocalDateTime().toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toLocalDate().atStartOfDay();
    }

    public static LocalDateTime toLocalDateTime(Timestamp timestamp) {
        return timestamp.toLocalDateTime();
    }

    public static LocalDate toLocalDate(java.util.Date date) {
        if (date instanceof Date) {
            return DateUtils.toLocalDate((Date)date);
        }
        if (date instanceof Timestamp) {
            return DateUtils.toLocalDate((Timestamp)date);
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(java.util.Date date) {
        if (date instanceof Date) {
            return DateUtils.toLocalDateTime((Date)date);
        }
        if (date instanceof Time) {
            return DateUtils.toLocalDateTime(new java.util.Date(((Time)date).getTime()));
        }
        if (date instanceof Timestamp) {
            return DateUtils.toLocalDateTime((Timestamp)date);
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static java.util.Date toDate(LocalDate localDate) {
        return Date.valueOf(localDate);
    }

    public static java.util.Date toDate(LocalDateTime localDateTime) {
        return Timestamp.valueOf(localDateTime);
    }

    public static LocalDate parseLocalDate(String date) {
        return LocalDate.parse(date);
    }

    public static LocalDate parseLocalDate(String date, DateTimeFormatter formatter) {
        return LocalDate.parse(date, formatter);
    }

    public static LocalDateTime parseLocalDateTime(String date) {
        return LocalDateTime.parse(date);
    }

    public static LocalDateTime parseLocalDateTime(String date, DateTimeFormatter formatter) {
        return LocalDateTime.parse(date, formatter);
    }

    public static DateTimeFormatter getPatternFormatter(String pattern) {
        return patternFormatterMap.computeIfAbsent(pattern, DateTimeFormatter::ofPattern);
    }

    public static DateTimeFormatter getLocalDateFormatter(Locale locale) {
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(DateUtils.getSafeLocale(locale));
    }

    public static DateTimeFormatter getLocalDateTimeFormatter(Locale locale, boolean withSeconds) {
        return DateTimeFormatter.ofLocalizedDateTime(withSeconds ? FormatStyle.MEDIUM : FormatStyle.SHORT).withLocale(DateUtils.getSafeLocale(locale));
    }

    public static String formatDate(LocalDate localDate, Locale locale) {
        if (localDate == null) {
            return "";
        }
        return DateUtils.getLocalDateFormatter(locale).format(localDate);
    }

    public static String formatDate(LocalDateTime localDateTime, Locale locale) {
        if (localDateTime == null) {
            return "";
        }
        return DateUtils.getLocalDateFormatter(locale).format(localDateTime.toLocalDate());
    }

    public static String formatDateTime(LocalDateTime localDateTime, Locale locale, boolean withSeconds) {
        if (localDateTime == null) {
            return "";
        }
        return DateUtils.getLocalDateTimeFormatter(locale, withSeconds).format(localDateTime);
    }
}

