/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBPreparable;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DBValueExpr
extends DBColumnExpr
implements DBPreparable {
    private static final Logger log = LoggerFactory.getLogger(DBValueExpr.class);
    public static String IGNORE_CASE_CONTEXT = "ignoreCaseContext";
    public final DBDatabase db;
    public final DataType type;
    protected Object value;
    private String name;
    private boolean literal = false;

    @Deprecated
    public DBValueExpr(DBDatabase db, Object value, DataType type) {
        if (value instanceof DBValueExpr) {
            throw new InvalidArgumentException("value", value);
        }
        this.db = db;
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (this.value instanceof DBCmdParam) {
            ((DBCmdParam)this.value).setValue(value);
        } else {
            if (this.type == DataType.UNKNOWN) {
                throw new PropertyReadOnlyException("value");
            }
            if (value != null && !this.isLiteralValue(value)) {
                throw new InvalidArgumentException("value", value);
            }
            this.value = ObjectUtils.convertValue(this.type, value);
            this.name = null;
        }
    }

    public final DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        if (this.value != null && this.value.getClass().isEnum()) {
            Class<Enum<?>> enumType = this.value.getClass();
            return enumType;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            int i;
            String str = String.valueOf(this.value);
            int l = Math.min(str.length(), 20);
            boolean valid = true;
            for (i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (c == '-' && i == 0) continue;
                boolean bl = valid = c == ' ' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
                if (!valid) break;
            }
            if (StringUtils.isNotEmpty(str = str.substring(str.charAt(0) == '-' ? 1 : 0, i))) {
                char c = str.charAt(0);
                if (c >= '0' && c <= '9') {
                    str = "N" + str;
                }
                this.name = "VAL_" + str.replace(' ', '_').toUpperCase();
            } else {
                this.name = "VALUE";
            }
        }
        return this.name;
    }

    @Override
    public DBRowSet getRowSet() {
        return null;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBValueExpr) {
            Object otherValue = ((DBValueExpr)other).value;
            return ObjectUtils.compareEqual(this.value, otherValue);
        }
        return false;
    }

    public DBColumnExpr getIgnoreCaseExpr(DBColumnExpr context) {
        if (!this.type.isText()) {
            return this;
        }
        this.setAttribute(IGNORE_CASE_CONTEXT, context);
        DBColumnExpr ignoreCaseExpr = super.getIgnoreCaseExpr();
        this.setAttribute(IGNORE_CASE_CONTEXT, null);
        return ignoreCaseExpr;
    }

    public DBValueExpr literal() {
        this.literal = true;
        if (this.value instanceof DBCmdParam) {
            this.value = ((DBCmdParam)this.value).getValue();
            this.name = null;
        }
        return this;
    }

    public DBValueExpr autoParam() {
        this.literal = false;
        return this;
    }

    @Override
    public void prepareParams(DBCommand cmd, DBExpr parent) {
        if (this.getDataType() == DataType.UNKNOWN || this.literal) {
            return;
        }
        if (this.value instanceof DBCmdParam) {
            if (cmd == ((DBCmdParam)this.value).getCmd()) {
                return;
            }
            log.warn("Unexpected behaviour: ValueExpr has alredy been used for a different command. Switching to literal mode!");
            this.literal();
            return;
        }
        if (this.value == null || this.value instanceof DBExpr || this.value instanceof DBDatabase.DBSystemDate) {
            return;
        }
        this.value = cmd.addParam(this.getDataType(), this.value);
        this.name = "P_" + String.valueOf(cmd.getParams().size());
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 4L) != 0L) {
            sql.appendValue(this.getDataType(), this.value);
        } else {
            log.warn("Cannot add SQL for DBValueExpr using context {}", (Object)context);
        }
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        String name = this.getName();
        if (name != null) {
            elem.setAttribute("name", this.getName());
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.type);
        }
        elem.setAttribute("function", "value");
        return elem;
    }
}

