/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.translator.TranslationException;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.ArrayDecoder;
import flex.messaging.io.amf.translator.decoder.BooleanDecoder;
import flex.messaging.io.amf.translator.decoder.CalendarDecoder;
import flex.messaging.io.amf.translator.decoder.CharacterDecoder;
import flex.messaging.io.amf.translator.decoder.CollectionDecoder;
import flex.messaging.io.amf.translator.decoder.DateDecoder;
import flex.messaging.io.amf.translator.decoder.EnumDecoder;
import flex.messaging.io.amf.translator.decoder.MapDecoder;
import flex.messaging.io.amf.translator.decoder.NativeDecoder;
import flex.messaging.io.amf.translator.decoder.NullDecoder;
import flex.messaging.io.amf.translator.decoder.NumberDecoder;
import flex.messaging.io.amf.translator.decoder.ReferenceAwareArrayDecoder;
import flex.messaging.io.amf.translator.decoder.ReferenceAwareCollectionDecoder;
import flex.messaging.io.amf.translator.decoder.ReferenceAwareMapDecoder;
import flex.messaging.io.amf.translator.decoder.ReferenceAwareTypedObjectDecoder;
import flex.messaging.io.amf.translator.decoder.StringDecoder;
import flex.messaging.io.amf.translator.decoder.TypedObjectDecoder;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class DecoderFactory {
    private static final NativeDecoder nativeDecoder = new NativeDecoder();
    private static final NullDecoder nullDecoder = new NullDecoder();
    private static final NumberDecoder numberDecoder = new NumberDecoder();
    private static final StringDecoder stringDecoder = new StringDecoder();
    private static final BooleanDecoder booleanDecoder = new BooleanDecoder();
    private static final CharacterDecoder characterDecoder = new CharacterDecoder();
    private static final DateDecoder dateDecoder = new DateDecoder();
    private static final CalendarDecoder calendarDecoder = new CalendarDecoder();
    private static final ArrayDecoder arrayDecoder = new ArrayDecoder();
    private static EnumDecoder enumDecoder = new EnumDecoder();
    private static final MapDecoder mapDecoder = new MapDecoder();
    private static final CollectionDecoder collectionDecoder = new CollectionDecoder();
    private static final TypedObjectDecoder typedObjectDecoder = new TypedObjectDecoder();
    private static final ArrayDecoder deepArrayDecoder = new ReferenceAwareArrayDecoder();
    private static final MapDecoder deepMapDecoder = new ReferenceAwareMapDecoder();
    private static final CollectionDecoder deepCollectionDecoder = new ReferenceAwareCollectionDecoder();
    private static final TypedObjectDecoder deepTypedObjectDecoder = new ReferenceAwareTypedObjectDecoder();

    public static ActionScriptDecoder getDecoderForShell(Class desiredClass) {
        if (desiredClass == null) {
            return nullDecoder;
        }
        if (Collection.class.isAssignableFrom(desiredClass)) {
            return collectionDecoder;
        }
        if (Map.class.isAssignableFrom(desiredClass)) {
            return mapDecoder;
        }
        if (desiredClass.isArray()) {
            return arrayDecoder;
        }
        if (desiredClass.isEnum()) {
            return enumDecoder;
        }
        return nativeDecoder;
    }

    public static ActionScriptDecoder getDecoder(Object encodedObject, Class desiredClass) {
        if (encodedObject != null) {
            if (desiredClass.isAssignableFrom(encodedObject.getClass())) {
                return nativeDecoder;
            }
            if (String.class.equals((Object)desiredClass)) {
                return stringDecoder;
            }
            if (DecoderFactory.isNumber(desiredClass)) {
                return numberDecoder;
            }
            if (DecoderFactory.isBoolean(desiredClass)) {
                return booleanDecoder;
            }
            if (Collection.class.isAssignableFrom(desiredClass)) {
                return collectionDecoder;
            }
            if (Map.class.isAssignableFrom(desiredClass)) {
                return mapDecoder;
            }
            if (desiredClass.isArray()) {
                return arrayDecoder;
            }
            if (DecoderFactory.isTypedObject(encodedObject)) {
                return typedObjectDecoder;
            }
            if (Date.class.isAssignableFrom(desiredClass)) {
                return dateDecoder;
            }
            if (Calendar.class.isAssignableFrom(desiredClass)) {
                return calendarDecoder;
            }
        }
        if (DecoderFactory.isNumber(desiredClass)) {
            return numberDecoder;
        }
        if (DecoderFactory.isBoolean(desiredClass)) {
            return booleanDecoder;
        }
        if (DecoderFactory.isCharacter(desiredClass)) {
            return characterDecoder;
        }
        if (encodedObject == null) {
            return nullDecoder;
        }
        if (desiredClass.isEnum()) {
            return enumDecoder;
        }
        DecoderFactory.invalidType(encodedObject, desiredClass);
        return nativeDecoder;
    }

    public static ActionScriptDecoder getReferenceAwareDecoder(Object encodedObject, Class desiredClass) {
        if (encodedObject != null) {
            if (String.class.equals((Object)desiredClass)) {
                return stringDecoder;
            }
            if (DecoderFactory.isNumber(desiredClass)) {
                return numberDecoder;
            }
            if (DecoderFactory.isBoolean(desiredClass)) {
                return booleanDecoder;
            }
            if (Collection.class.isAssignableFrom(desiredClass)) {
                return deepCollectionDecoder;
            }
            if (Map.class.isAssignableFrom(desiredClass)) {
                return deepMapDecoder;
            }
            if (desiredClass.isArray()) {
                return deepArrayDecoder;
            }
            if (DecoderFactory.isTypedObject(encodedObject)) {
                return deepTypedObjectDecoder;
            }
            if (Date.class.isAssignableFrom(desiredClass)) {
                return dateDecoder;
            }
            if (Calendar.class.isAssignableFrom(desiredClass)) {
                return calendarDecoder;
            }
            if (DecoderFactory.isCharacter(desiredClass)) {
                return characterDecoder;
            }
            if (desiredClass.isAssignableFrom(encodedObject.getClass())) {
                return nativeDecoder;
            }
        }
        if (DecoderFactory.isNumber(desiredClass)) {
            return numberDecoder;
        }
        if (DecoderFactory.isBoolean(desiredClass)) {
            return booleanDecoder;
        }
        if (DecoderFactory.isCharacter(desiredClass)) {
            return characterDecoder;
        }
        if (encodedObject == null) {
            return nullDecoder;
        }
        DecoderFactory.invalidType(encodedObject, desiredClass);
        return nativeDecoder;
    }

    public static boolean isNumber(Class desiredClass) {
        boolean isNum = false;
        if (desiredClass.isPrimitive()) {
            if (desiredClass.equals(Integer.TYPE) || desiredClass.equals(Double.TYPE) || desiredClass.equals(Long.TYPE) || desiredClass.equals(Float.TYPE) || desiredClass.equals(Short.TYPE) || desiredClass.equals(Byte.TYPE)) {
                isNum = true;
            }
        } else if (Number.class.isAssignableFrom(desiredClass)) {
            isNum = true;
        }
        return isNum;
    }

    public static boolean isCharacter(Class desiredClass) {
        boolean isChar = false;
        if (desiredClass.isPrimitive() && desiredClass.equals(Character.TYPE)) {
            isChar = true;
        } else if (desiredClass.equals(Character.class)) {
            isChar = true;
        }
        return isChar;
    }

    public static boolean isBoolean(Class desiredClass) {
        boolean isBool = false;
        if (desiredClass.isPrimitive() && desiredClass.equals(Boolean.TYPE)) {
            isBool = true;
        } else if (desiredClass.equals(Boolean.class)) {
            isBool = true;
        }
        return isBool;
    }

    public static boolean isCharArray(Class desiredClass) {
        Class<?> type;
        boolean isCharArray = false;
        if (desiredClass.isArray() && (type = desiredClass.getComponentType()) != null && type.equals(Character.TYPE)) {
            isCharArray = true;
        }
        return isCharArray;
    }

    public static boolean isTypedObject(Object encodedObject) {
        boolean typed = false;
        if (encodedObject instanceof ASObject) {
            typed = TypeMarshallingContext.getType(encodedObject) != null;
        }
        return typed;
    }

    public static void invalidType(Object object, Class desiredClass) {
        String inputType = null;
        if (object != null) {
            inputType = object.getClass().getName();
        }
        StringBuffer message = new StringBuffer("Cannot convert ");
        if (inputType != null) {
            message.append("type ").append(inputType).append(" ");
        }
        if (object != null && (object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Date)) {
            message.append("with value '").append(object.toString()).append("' ");
        } else if (object instanceof ASObject) {
            ASObject aso = (ASObject)object;
            message.append("with remote type specified as '").append(aso.getType()).append("' ");
        }
        message.append("to an instance of ").append(desiredClass.toString());
        TranslationException ex = new TranslationException(message.toString());
        ex.setCode("Client.Message.Deserialize.InvalidType");
        throw ex;
    }
}

