/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.client.UserAgentSettings;
import flex.messaging.config.ConfigMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserAgentManager {
    public static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final String KICKSTART_BYTES = "kickstart-bytes";
    private static final String MATCH_ON = "match-on";
    public static final String MAX_STREAMING_CONNECTIONS_PER_SESSION = "max-streaming-connections-per-session";
    public static final String MAX_PERSISTENT_CONNECTIONS_PER_SESSION = "max-persistent-connections-per-session";
    private static final String USER_AGENT = "user-agent";
    private static final String USER_AGENT_SETTINGS = "user-agent-settings";
    private Map<String, UserAgentSettings> userAgentSettingsMap = new HashMap<String, UserAgentSettings>();
    private UserAgentSettings defaultSettings;

    public UserAgentSettings getUserAgentSettings(String matchOn) {
        return this.userAgentSettingsMap.get(matchOn);
    }

    public Collection<UserAgentSettings> getUserAgentSettings() {
        return this.userAgentSettingsMap.values();
    }

    public void putUserAgentSettings(UserAgentSettings userAgent) {
        this.userAgentSettingsMap.put(userAgent.getMatchOn(), userAgent);
    }

    public void removeUserAgentSettings(UserAgentSettings userAgent) {
        if (userAgent != null) {
            this.userAgentSettingsMap.remove(userAgent.getMatchOn());
        }
    }

    public void setDefaultUserAgentSettings(UserAgentSettings settings) {
        this.defaultSettings = settings;
    }

    public UserAgentSettings match(String userAgent) {
        if (userAgent != null && this.userAgentSettingsMap.size() > 0) {
            int bestMatchLength = 0;
            String matchedAgent = null;
            for (String key : this.userAgentSettingsMap.keySet()) {
                int matchLength;
                if (userAgent.indexOf(key) == -1 || (matchLength = key.length()) <= bestMatchLength) continue;
                bestMatchLength = matchLength;
                matchedAgent = key;
            }
            if (matchedAgent != null) {
                return this.userAgentSettingsMap.get(matchedAgent);
            }
        }
        return this.defaultSettings;
    }

    public static void setupUserAgentManager(ConfigMap properties, UserAgentManager manager) {
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Android"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Chrome"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Firefox"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Firefox/1"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Firefox/2"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("MSIE"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("MSIE 5"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("MSIE 6"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("MSIE 7"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Opera"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Opera 8"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Opera/9.8"));
        manager.putUserAgentSettings(UserAgentSettings.getAgent("Safari"));
        if (properties == null) {
            return;
        }
        ConfigMap userAgents = properties.getPropertyAsMap(USER_AGENT_SETTINGS, null);
        if (userAgents == null) {
            return;
        }
        List userAgent = userAgents.getPropertyAsList(USER_AGENT, null);
        if (userAgent == null || userAgent.size() == 0) {
            return;
        }
        for (Object anUserAgent : userAgent) {
            ConfigMap agent = (ConfigMap)anUserAgent;
            String matchOn = agent.getPropertyAsString(MATCH_ON, null);
            if (matchOn == null) continue;
            int kickstartBytes = agent.getPropertyAsInt(KICKSTART_BYTES, 0);
            int connectionsPerSession = agent.getPropertyAsInt(MAX_PERSISTENT_CONNECTIONS_PER_SESSION, agent.getPropertyAsInt(MAX_STREAMING_CONNECTIONS_PER_SESSION, 5));
            UserAgentSettings ua = UserAgentSettings.getAgent(matchOn);
            ua.setKickstartBytes(kickstartBytes);
            ua.setMaxPersistentConnectionsPerSession(connectionsPerSession);
            if (matchOn.equals("*")) {
                manager.setDefaultUserAgentSettings(ua);
                continue;
            }
            manager.putUserAgentSettings(ua);
        }
    }
}

