////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package org.apache.flex.events.utils
{
	/**
	 *  This class holds constants for special keys
     *  See: https://w3c.github.io/uievents-key/#keys-ui
     *  See: https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#UI_keys
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 10.2
	 *  @playerversion AIR 2.6
	 *  @productversion FlexJS 0.8
	 */
    public class UIKeys
    {
        
        /**
         * The Accept, Commit, or OK key or button. Accepts the currently selected option or input method sequence conversion.
         */
        public static const ACCEPT:String = "Accept";
        
        /**
         * The Again key. Redoes or repeats a previous action.
         */
        public static const AGAIN:String = "Again";
        
        /**
         * The Attn (Attention) key.
         */
        public static const ATTN:String = "Attn";
        
        /**
         * The Cancel key.
         */
        public static const CANCEL:String = "Cancel";
        
        /**
         * Shows the context menu. Typically found between the Windows (or OS) key and the Control key on the right side of the keyboard.
         */
        public static const CONTEXT_MENU:String = "ContextMenu";
        
        /**
         * The Esc (Escape) key. Typically used as an exit, cancel, or "escape this operation" button. Historically, the Escape character was used to signal the start of a special control sequence of characters called an "escape sequence."
         */
        public static const ESCAPE:String = "Escape";
        
        /**
         * The Execute key.
         */
        public static const EXECUTE:String = "Execute";
        
        /**
         * The Find key. Opens an interface (typically a dialog box) for performing a find/search operation.
         */
        public static const FIND:String = "Find";
        
        /**
         * The Finish key.
         */
        public static const FINISH:String = "Finish";
        
        /**
         * The Help key. Opens or toggles the display of help information.
         */
        public static const HELP:String = "Help";
        
        /**
         * The Pause key. Pauses the current application or state, if applicable.
         */
        public static const PAUSE:String = "Pause";
        
        /**
         * The Play key. Resumes a previously paused application, if applicable.
         */
        public static const PLAY:String = "Play";
        
        /**
         * The Props (Properties) key.
         */
        public static const PROPS:String = "Props";
        
        /**
         * The Select key.
         */
        public static const SELECT:String = "Select";
        
        /**
         * The ZoomIn key.
         */
        public static const ZOOM_IN:String = "ZoomIn";
        
        /**
         * The ZoomOut key.
         */
        public static const ZOOM_OUT:String = "ZoomOut";

    }
}