/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.chat.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.flink.agents.api.chat.messages.ChatMessage;
import org.apache.flink.agents.api.chat.messages.MessageRole;
import org.apache.flink.agents.api.chat.model.BaseChatModelConnection;
import org.apache.flink.agents.api.prompt.Prompt;
import org.apache.flink.agents.api.resource.Resource;
import org.apache.flink.agents.api.resource.ResourceDescriptor;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.tools.Tool;
import org.apache.flink.annotation.VisibleForTesting;

public abstract class BaseChatModelSetup
extends Resource {
    protected final String connection;
    protected String model;
    protected Object prompt;
    protected List<String> tools;

    public BaseChatModelSetup(ResourceDescriptor descriptor, BiFunction<String, ResourceType, Resource> getResource) {
        super(descriptor, getResource);
        this.connection = (String)descriptor.getArgument("connection");
        this.model = (String)descriptor.getArgument("model");
        this.prompt = descriptor.getArgument("prompt");
        this.tools = (List)descriptor.getArgument("tools");
    }

    public abstract Map<String, Object> getParameters();

    public ChatMessage chat(List<ChatMessage> messages) {
        return this.chat(messages, Collections.emptyMap());
    }

    public ChatMessage chat(List<ChatMessage> messages, Map<String, Object> parameters) {
        BaseChatModelConnection connection = (BaseChatModelConnection)this.getResource.apply(this.connection, ResourceType.CHAT_MODEL_CONNECTION);
        if (this.prompt != null) {
            if (this.prompt instanceof String) {
                this.prompt = this.getResource.apply((String)this.prompt, ResourceType.PROMPT);
            }
            Prompt prompt = (Prompt)this.prompt;
            HashMap arguments = new HashMap();
            for (ChatMessage message : messages) {
                for (Map.Entry<String, Object> entry : message.getExtraArgs().entrySet()) {
                    arguments.put(entry.getKey(), entry.getValue().toString());
                }
            }
            messages = prompt.formatMessages(MessageRole.USER, arguments);
        }
        ArrayList<Tool> tools = new ArrayList<Tool>();
        if (this.tools != null) {
            for (String name : this.tools) {
                tools.add((Tool)this.getResource.apply(name, ResourceType.TOOL));
            }
        }
        Map<String, Object> params = this.getParameters();
        params.putAll(parameters);
        return connection.chat(messages, tools, params);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CHAT_MODEL;
    }

    @VisibleForTesting
    public String getConnection() {
        return this.connection;
    }

    @VisibleForTesting
    public String getModel() {
        return this.model;
    }

    @VisibleForTesting
    public Object getPrompt() {
        return this.prompt;
    }

    @VisibleForTesting
    public List<String> getTools() {
        return this.tools;
    }
}

