/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.feedback;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.agents.runtime.feedback.SubtaskFeedbackKey;

public final class FeedbackKey<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String pipelineName;
    private final long invocationId;

    public FeedbackKey(String pipelineName, long invocationId) {
        this.pipelineName = Objects.requireNonNull(pipelineName);
        this.invocationId = invocationId;
    }

    public SubtaskFeedbackKey<V> withSubTaskIndex(int subTaskIndex, int attemptId) {
        return new SubtaskFeedbackKey(this.pipelineName, this.invocationId, subTaskIndex, attemptId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedbackKey that = (FeedbackKey)o;
        return this.invocationId == that.invocationId && Objects.equals(this.pipelineName, that.pipelineName);
    }

    public int hashCode() {
        return Objects.hash(this.pipelineName, this.invocationId);
    }

    public String asColocationKey() {
        return String.format("CO-LOCATION/%s/%d", this.pipelineName, this.invocationId);
    }
}

