/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;

public interface CompletableEvent<T> {
    public CompletableFuture<T> future();

    public long deadlineMs();

    public static long calculateDeadlineMs(Timer timer) {
        Objects.requireNonNull(timer);
        return CompletableEvent.calculateDeadlineMs(timer.currentTimeMs(), timer.remainingMs());
    }

    public static long calculateDeadlineMs(Time time, Duration duration) {
        return CompletableEvent.calculateDeadlineMs(Objects.requireNonNull(time).milliseconds(), Objects.requireNonNull(duration).toMillis());
    }

    public static long calculateDeadlineMs(Time time, long timeoutMs) {
        return CompletableEvent.calculateDeadlineMs(Objects.requireNonNull(time).milliseconds(), timeoutMs);
    }

    public static long calculateDeadlineMs(long currentTimeMs, long timeoutMs) {
        if (currentTimeMs > Long.MAX_VALUE - timeoutMs) {
            return Long.MAX_VALUE;
        }
        return currentTimeMs + timeoutMs;
    }
}

