/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ShareFetchRequestDataJsonConverter {
    public static ShareFetchRequestData read(JsonNode _node, short _version) {
        ShareFetchRequestData _object = new ShareFetchRequestData();
        JsonNode _groupIdNode = _node.get("groupId");
        if (_groupIdNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'groupId', which is mandatory in version " + _version);
        }
        if (_groupIdNode.isNull()) {
            _object.groupId = null;
        } else {
            if (!_groupIdNode.isTextual()) {
                throw new RuntimeException("ShareFetchRequestData expected a string type, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            _object.groupId = _groupIdNode.asText();
        }
        JsonNode _memberIdNode = _node.get("memberId");
        if (_memberIdNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'memberId', which is mandatory in version " + _version);
        }
        if (_memberIdNode.isNull()) {
            _object.memberId = null;
        } else {
            if (!_memberIdNode.isTextual()) {
                throw new RuntimeException("ShareFetchRequestData expected a string type, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            _object.memberId = _memberIdNode.asText();
        }
        JsonNode _shareSessionEpochNode = _node.get("shareSessionEpoch");
        if (_shareSessionEpochNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'shareSessionEpoch', which is mandatory in version " + _version);
        }
        _object.shareSessionEpoch = MessageUtil.jsonNodeToInt(_shareSessionEpochNode, "ShareFetchRequestData");
        JsonNode _maxWaitMsNode = _node.get("maxWaitMs");
        if (_maxWaitMsNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'maxWaitMs', which is mandatory in version " + _version);
        }
        _object.maxWaitMs = MessageUtil.jsonNodeToInt(_maxWaitMsNode, "ShareFetchRequestData");
        JsonNode _minBytesNode = _node.get("minBytes");
        if (_minBytesNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'minBytes', which is mandatory in version " + _version);
        }
        _object.minBytes = MessageUtil.jsonNodeToInt(_minBytesNode, "ShareFetchRequestData");
        JsonNode _maxBytesNode = _node.get("maxBytes");
        if (_maxBytesNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'maxBytes', which is mandatory in version " + _version);
        }
        _object.maxBytes = MessageUtil.jsonNodeToInt(_maxBytesNode, "ShareFetchRequestData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ShareFetchRequestData expected a JSON array, but got " + String.valueOf((Object)_node.getNodeType()));
        }
        ArrayList<ShareFetchRequestData.FetchTopic> _collection = new ArrayList<ShareFetchRequestData.FetchTopic>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(FetchTopicJsonConverter.read(_element, _version));
        }
        JsonNode _forgottenTopicsDataNode = _node.get("forgottenTopicsData");
        if (_forgottenTopicsDataNode == null) {
            throw new RuntimeException("ShareFetchRequestData: unable to locate field 'forgottenTopicsData', which is mandatory in version " + _version);
        }
        if (!_forgottenTopicsDataNode.isArray()) {
            throw new RuntimeException("ShareFetchRequestData expected a JSON array, but got " + String.valueOf((Object)_node.getNodeType()));
        }
        ArrayList<ShareFetchRequestData.ForgottenTopic> _collection2 = new ArrayList<ShareFetchRequestData.ForgottenTopic>(_forgottenTopicsDataNode.size());
        _object.forgottenTopicsData = _collection2;
        for (JsonNode _element : _forgottenTopicsDataNode) {
            _collection2.add(ForgottenTopicJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ShareFetchRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_object.groupId == null) {
            _node.set("groupId", NullNode.instance);
        } else {
            _node.set("groupId", new TextNode(_object.groupId));
        }
        if (_object.memberId == null) {
            _node.set("memberId", NullNode.instance);
        } else {
            _node.set("memberId", new TextNode(_object.memberId));
        }
        _node.set("shareSessionEpoch", new IntNode(_object.shareSessionEpoch));
        _node.set("maxWaitMs", new IntNode(_object.maxWaitMs));
        _node.set("minBytes", new IntNode(_object.minBytes));
        _node.set("maxBytes", new IntNode(_object.maxBytes));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ShareFetchRequestData.FetchTopic _element : _object.topics) {
            _topicsArray.add(FetchTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", _topicsArray);
        ArrayNode _forgottenTopicsDataArray = new ArrayNode(JsonNodeFactory.instance);
        for (ShareFetchRequestData.ForgottenTopic _element : _object.forgottenTopicsData) {
            _forgottenTopicsDataArray.add(ForgottenTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("forgottenTopicsData", _forgottenTopicsDataArray);
        return _node;
    }

    public static JsonNode write(ShareFetchRequestData _object, short _version) {
        return ShareFetchRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class FetchTopicJsonConverter {
        public static ShareFetchRequestData.FetchTopic read(JsonNode _node, short _version) {
            ShareFetchRequestData.FetchTopic _object = new ShareFetchRequestData.FetchTopic();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("FetchTopic: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("FetchTopic expected a JSON string type, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("FetchTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("FetchTopic expected a JSON array, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            ArrayList<ShareFetchRequestData.FetchPartition> _collection = new ArrayList<ShareFetchRequestData.FetchPartition>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(FetchPartitionJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ShareFetchRequestData.FetchTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ShareFetchRequestData.FetchPartition _element : _object.partitions) {
                _partitionsArray.add(FetchPartitionJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }

        public static JsonNode write(ShareFetchRequestData.FetchTopic _object, short _version) {
            return FetchTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class ForgottenTopicJsonConverter {
        public static ShareFetchRequestData.ForgottenTopic read(JsonNode _node, short _version) {
            ShareFetchRequestData.ForgottenTopic _object = new ShareFetchRequestData.ForgottenTopic();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("ForgottenTopic: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("ForgottenTopic expected a JSON string type, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ForgottenTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ForgottenTopic expected a JSON array, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "ForgottenTopic element"));
            }
            return _object;
        }

        public static JsonNode write(ShareFetchRequestData.ForgottenTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add(new IntNode(_element));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }

        public static JsonNode write(ShareFetchRequestData.ForgottenTopic _object, short _version) {
            return ForgottenTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class FetchPartitionJsonConverter {
        public static ShareFetchRequestData.FetchPartition read(JsonNode _node, short _version) {
            ShareFetchRequestData.FetchPartition _object = new ShareFetchRequestData.FetchPartition();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("FetchPartition: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "FetchPartition");
            JsonNode _partitionMaxBytesNode = _node.get("partitionMaxBytes");
            if (_partitionMaxBytesNode == null) {
                throw new RuntimeException("FetchPartition: unable to locate field 'partitionMaxBytes', which is mandatory in version " + _version);
            }
            _object.partitionMaxBytes = MessageUtil.jsonNodeToInt(_partitionMaxBytesNode, "FetchPartition");
            JsonNode _acknowledgementBatchesNode = _node.get("acknowledgementBatches");
            if (_acknowledgementBatchesNode == null) {
                throw new RuntimeException("FetchPartition: unable to locate field 'acknowledgementBatches', which is mandatory in version " + _version);
            }
            if (!_acknowledgementBatchesNode.isArray()) {
                throw new RuntimeException("FetchPartition expected a JSON array, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            ArrayList<ShareFetchRequestData.AcknowledgementBatch> _collection = new ArrayList<ShareFetchRequestData.AcknowledgementBatch>(_acknowledgementBatchesNode.size());
            _object.acknowledgementBatches = _collection;
            for (JsonNode _element : _acknowledgementBatchesNode) {
                _collection.add(AcknowledgementBatchJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ShareFetchRequestData.FetchPartition _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", new IntNode(_object.partitionIndex));
            _node.set("partitionMaxBytes", new IntNode(_object.partitionMaxBytes));
            ArrayNode _acknowledgementBatchesArray = new ArrayNode(JsonNodeFactory.instance);
            for (ShareFetchRequestData.AcknowledgementBatch _element : _object.acknowledgementBatches) {
                _acknowledgementBatchesArray.add(AcknowledgementBatchJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("acknowledgementBatches", _acknowledgementBatchesArray);
            return _node;
        }

        public static JsonNode write(ShareFetchRequestData.FetchPartition _object, short _version) {
            return FetchPartitionJsonConverter.write(_object, _version, true);
        }
    }

    public static class AcknowledgementBatchJsonConverter {
        public static ShareFetchRequestData.AcknowledgementBatch read(JsonNode _node, short _version) {
            ShareFetchRequestData.AcknowledgementBatch _object = new ShareFetchRequestData.AcknowledgementBatch();
            JsonNode _firstOffsetNode = _node.get("firstOffset");
            if (_firstOffsetNode == null) {
                throw new RuntimeException("AcknowledgementBatch: unable to locate field 'firstOffset', which is mandatory in version " + _version);
            }
            _object.firstOffset = MessageUtil.jsonNodeToLong(_firstOffsetNode, "AcknowledgementBatch");
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("AcknowledgementBatch: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            }
            _object.lastOffset = MessageUtil.jsonNodeToLong(_lastOffsetNode, "AcknowledgementBatch");
            JsonNode _acknowledgeTypesNode = _node.get("acknowledgeTypes");
            if (_acknowledgeTypesNode == null) {
                throw new RuntimeException("AcknowledgementBatch: unable to locate field 'acknowledgeTypes', which is mandatory in version " + _version);
            }
            if (!_acknowledgeTypesNode.isArray()) {
                throw new RuntimeException("AcknowledgementBatch expected a JSON array, but got " + String.valueOf((Object)_node.getNodeType()));
            }
            ArrayList<Byte> _collection = new ArrayList<Byte>(_acknowledgeTypesNode.size());
            _object.acknowledgeTypes = _collection;
            for (JsonNode _element : _acknowledgeTypesNode) {
                _collection.add(MessageUtil.jsonNodeToByte(_element, "AcknowledgementBatch element"));
            }
            return _object;
        }

        public static JsonNode write(ShareFetchRequestData.AcknowledgementBatch _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("firstOffset", new LongNode(_object.firstOffset));
            _node.set("lastOffset", new LongNode(_object.lastOffset));
            ArrayNode _acknowledgeTypesArray = new ArrayNode(JsonNodeFactory.instance);
            for (Byte _element : _object.acknowledgeTypes) {
                _acknowledgeTypesArray.add(new ShortNode(_element.byteValue()));
            }
            _node.set("acknowledgeTypes", _acknowledgeTypesArray);
            return _node;
        }

        public static JsonNode write(ShareFetchRequestData.AcknowledgementBatch _object, short _version) {
            return AcknowledgementBatchJsonConverter.write(_object, _version, true);
        }
    }
}

