/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorNotifier.class);
    private final ScheduledExecutorService workerExecutor;
    private final Executor executorToNotify;

    public ExecutorNotifier(ScheduledExecutorService workerExecutor, Executor executorToNotify) {
        this.executorToNotify = executorToNotify;
        this.workerExecutor = workerExecutor;
    }

    public <T> void notifyReadyAsync(Callable<T> callable, BiConsumer<T, Throwable> handler) {
        this.workerExecutor.execute(() -> {
            try {
                Object result = callable.call();
                this.executorToNotify.execute(() -> handler.accept(result, null));
            }
            catch (Throwable t) {
                this.executorToNotify.execute(() -> handler.accept(null, t));
            }
        });
    }

    public <T> void notifyReadyAsync(Callable<T> callable, BiConsumer<T, Throwable> handler, long initialDelayMs, long periodMs) {
        this.workerExecutor.scheduleAtFixedRate(() -> {
            try {
                Object result = callable.call();
                this.executorToNotify.execute(() -> handler.accept(result, null));
            }
            catch (Throwable t) {
                this.executorToNotify.execute(() -> handler.accept(null, t));
            }
        }, initialDelayMs, periodMs, TimeUnit.MILLISECONDS);
    }
}

