/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.sources.TableSource;

@Internal
public class TableSourceQueryOperation<T>
implements QueryOperation {
    private final TableSource<T> tableSource;
    private final boolean isBatch;

    public TableSourceQueryOperation(TableSource<T> tableSource, boolean isBatch) {
        this.tableSource = tableSource;
        this.isBatch = isBatch;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        TableSchema legacySchema = this.tableSource.getTableSchema();
        return ResolvedSchema.physical(legacySchema.getFieldNames(), legacySchema.getFieldDataTypes());
    }

    @Override
    public String asSummaryString() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("fields", this.tableSource.getTableSchema().getFieldNames());
        return OperationUtils.formatWithChildren("TableSource", args, this.getChildren(), Operation::asSummaryString);
    }

    public TableSource<T> getTableSource() {
        return this.tableSource;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <R> R accept(QueryOperationVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

