/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

public class AddPartitionsOperation
extends AlterTableOperation {
    private final boolean ifNotExists;
    private final List<CatalogPartitionSpec> partitionSpecs;
    private final List<CatalogPartition> catalogPartitions;

    public AddPartitionsOperation(ObjectIdentifier tableIdentifier, boolean ifNotExists, List<CatalogPartitionSpec> partitionSpecs, List<CatalogPartition> catalogPartitions) {
        super(tableIdentifier);
        this.ifNotExists = ifNotExists;
        this.partitionSpecs = partitionSpecs;
        this.catalogPartitions = catalogPartitions;
    }

    public List<CatalogPartitionSpec> getPartitionSpecs() {
        return this.partitionSpecs;
    }

    public List<CatalogPartition> getCatalogPartitions() {
        return this.catalogPartitions;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder(String.format("ALTER TABLE %s ADD", this.tableIdentifier.asSummaryString()));
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        for (int i = 0; i < this.partitionSpecs.size(); ++i) {
            String spec = OperationUtils.formatPartitionSpec(this.partitionSpecs.get(i));
            builder.append(String.format(" PARTITION (%s)", spec));
            Map<String, String> properties = this.catalogPartitions.get(i).getProperties();
            if (properties.isEmpty()) continue;
            builder.append(String.format(" WITH (%s)", OperationUtils.formatProperties(properties)));
        }
        return builder.toString();
    }
}

