/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.util.WindowKey;

public class WindowKeySerializer
extends PagedTypeSerializer<WindowKey> {
    private static final long serialVersionUID = 1L;
    public static final int WINDOW_IN_BYTES = 8;
    private final PagedTypeSerializer<RowData> keySerializer;

    public WindowKeySerializer(PagedTypeSerializer<RowData> keySerializer) {
        this.keySerializer = keySerializer;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<WindowKey> duplicate() {
        return new WindowKeySerializer((PagedTypeSerializer)this.keySerializer.duplicate());
    }

    @Override
    public WindowKey createInstance() {
        return new WindowKey(Long.MIN_VALUE, (RowData)this.keySerializer.createInstance());
    }

    @Override
    public WindowKey copy(WindowKey from) {
        return new WindowKey(from.getWindow(), this.keySerializer.copy(from.getKey()));
    }

    @Override
    public WindowKey copy(WindowKey from, WindowKey reuse) {
        long window = from.getWindow();
        RowData key = this.keySerializer.copy(from.getKey(), reuse.getKey());
        return reuse.replace(window, key);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(WindowKey record, DataOutputView target) throws IOException {
        target.writeLong(record.getWindow());
        this.keySerializer.serialize(record.getKey(), target);
    }

    @Override
    public WindowKey deserialize(DataInputView source) throws IOException {
        long window = source.readLong();
        RowData key = (RowData)this.keySerializer.deserialize(source);
        return new WindowKey(window, key);
    }

    @Override
    public WindowKey deserialize(WindowKey reuse, DataInputView source) throws IOException {
        long window = source.readLong();
        RowData key = this.keySerializer.deserialize(reuse.getKey(), source);
        return reuse.replace(window, key);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
        this.keySerializer.copy(source, target);
    }

    @Override
    public int serializeToPages(WindowKey record, AbstractPagedOutputView target) throws IOException {
        target.writeLong(record.getWindow());
        this.keySerializer.serializeToPages(record.getKey(), target);
        return 0;
    }

    @Override
    public WindowKey deserializeFromPages(AbstractPagedInputView source) throws IOException {
        return this.deserializeFromPages(this.createInstance(), source);
    }

    @Override
    public WindowKey deserializeFromPages(WindowKey reuse, AbstractPagedInputView source) throws IOException {
        long window = source.readLong();
        RowData key = this.keySerializer.deserializeFromPages(reuse.getKey(), source);
        return reuse.replace(window, key);
    }

    @Override
    public WindowKey mapFromPages(WindowKey reuse, AbstractPagedInputView source) throws IOException {
        long window = source.readLong();
        RowData key = this.keySerializer.mapFromPages(reuse.getKey(), source);
        return reuse.replace(window, key);
    }

    @Override
    public void skipRecordFromPages(AbstractPagedInputView source) throws IOException {
        source.skipBytes(8);
        this.keySerializer.skipRecordFromPages(source);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof WindowKeySerializer && this.keySerializer.equals(((WindowKeySerializer)obj).keySerializer);
    }

    @Override
    public int hashCode() {
        return this.keySerializer.hashCode();
    }

    @Override
    public TypeSerializerSnapshot<WindowKey> snapshotConfiguration() {
        return new WindowKeySerializerSnapshot(this);
    }

    public static final class WindowKeySerializerSnapshot
    extends CompositeTypeSerializerSnapshot<WindowKey, WindowKeySerializer> {
        private static final int CURRENT_VERSION = 1;

        public WindowKeySerializerSnapshot() {
            super(WindowKeySerializer.class);
        }

        public WindowKeySerializerSnapshot(WindowKeySerializer serializerInstance) {
            super(serializerInstance);
        }

        @Override
        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        @Override
        protected TypeSerializer<?>[] getNestedSerializers(WindowKeySerializer outerSerializer) {
            return new TypeSerializer[]{outerSerializer.keySerializer};
        }

        @Override
        protected WindowKeySerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new WindowKeySerializer((PagedTypeSerializer)nestedSerializers[0]);
        }
    }
}

